/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.AMQConnection;
import java.io.IOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.ObjectUtils;

public class SimpleConnection
implements Connection {
    private final com.rabbitmq.client.Connection delegate;
    private final int closeTimeout;

    public SimpleConnection(com.rabbitmq.client.Connection delegate, int closeTimeout) {
        this.delegate = delegate;
        this.closeTimeout = closeTimeout;
    }

    @Override
    public Channel createChannel(boolean transactional) {
        try {
            Channel channel = this.delegate.createChannel();
            if (transactional) {
                channel.txSelect();
            }
            return channel;
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.delegate.close(this.closeTimeout);
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate != null && (this.delegate.isOpen() || this.delegate.getClass().getSimpleName().contains("AutorecoveringConnection"));
    }

    @Override
    public int getLocalPort() {
        if (this.delegate instanceof AMQConnection) {
            return ((AMQConnection)this.delegate).getLocalPort();
        }
        return 0;
    }

    public String toString() {
        return "SimpleConnection@" + ObjectUtils.getIdentityHexString((Object)this) + " [delegate=" + this.delegate + ", localPort= " + this.getLocalPort() + "]";
    }
}

