/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

final class MicrometerHolder {
    private final ConcurrentMap<String, Timer> timers = new ConcurrentHashMap<String, Timer>();
    private final MeterRegistry registry;
    private final Map<String, String> tags;
    private final String listenerId;

    MicrometerHolder(@Nullable ApplicationContext context, String listenerId, Map<String, String> tags) {
        if (context == null) {
            throw new IllegalStateException("No micrometer registry present");
        }
        try {
            this.registry = (MeterRegistry)context.getBeanProvider(MeterRegistry.class).getIfUnique();
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.registry == null) {
            throw new IllegalStateException("No micrometer registry present (or more than one and there is not exactly one marked with @Primary)");
        }
        this.listenerId = listenerId;
        this.tags = tags;
    }

    Object start() {
        return Timer.start((MeterRegistry)this.registry);
    }

    void success(Object sample, String queue) {
        Timer timer = (Timer)this.timers.get(queue + "none");
        if (timer == null) {
            timer = this.buildTimer(this.listenerId, "success", queue, "none");
        }
        ((Timer.Sample)sample).stop(timer);
    }

    void failure(Object sample, String queue, String exception) {
        Timer timer = (Timer)this.timers.get(queue + exception);
        if (timer == null) {
            timer = this.buildTimer(this.listenerId, "failure", queue, exception);
        }
        ((Timer.Sample)sample).stop(timer);
    }

    private Timer buildTimer(String aListenerId, String result, String queue, String exception) {
        Timer.Builder builder = Timer.builder((String)"spring.rabbitmq.listener").description("Spring RabbitMQ Listener").tag("listener.id", aListenerId).tag("queue", queue).tag("result", result).tag("exception", exception);
        if (this.tags != null && !this.tags.isEmpty()) {
            this.tags.forEach((key, value) -> builder.tag(key, value));
        }
        Timer registeredTimer = builder.register(this.registry);
        this.timers.put(queue + exception, registeredTimer);
        return registeredTimer;
    }

    void destroy() {
        this.timers.values().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.timers.clear();
    }
}

