/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support.builder;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemProcessor;
import org.springframework.batch.infrastructure.item.support.CompositeItemProcessor;
import org.springframework.util.Assert;

public class CompositeItemProcessorBuilder<I, O> {
    private @Nullable List<? extends ItemProcessor<?, ?>> delegates;

    public CompositeItemProcessorBuilder<I, O> delegates(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
        return this;
    }

    public CompositeItemProcessorBuilder<I, O> delegates(ItemProcessor<?, ?> ... delegates) {
        return this.delegates(Arrays.asList(delegates));
    }

    public CompositeItemProcessor<I, O> build() {
        Assert.notNull(this.delegates, (String)"A list of delegates is required.");
        Assert.notEmpty(this.delegates, (String)"The delegates list must have one or more delegates.");
        CompositeItemProcessor processor = new CompositeItemProcessor(new ItemProcessor[0]);
        processor.setDelegates(this.delegates);
        return processor;
    }
}

