/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.autoconfigure;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.mongodb.autoconfigure.DataMongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={MongoDatabaseFactory.class})
class MongoDatabaseFactoryDependentConfiguration {
    MongoDatabaseFactoryDependentConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoOperations.class})
    MongoTemplate mongoTemplate(MongoDatabaseFactory factory, MongoConverter converter) {
        return new MongoTemplate(factory, converter);
    }

    @Bean
    @ConditionalOnMissingBean(value={GridFsOperations.class})
    GridFsTemplate gridFsTemplate(DataMongoProperties properties, MongoDatabaseFactory factory, MongoTemplate mongoTemplate) {
        return new GridFsTemplate((MongoDatabaseFactory)new GridFsMongoDatabaseFactory(factory, properties), mongoTemplate.getConverter(), properties.getGridfs().getBucket());
    }

    static class GridFsMongoDatabaseFactory
    implements MongoDatabaseFactory {
        private final MongoDatabaseFactory mongoDatabaseFactory;
        private final DataMongoProperties properties;

        GridFsMongoDatabaseFactory(MongoDatabaseFactory mongoDatabaseFactory, DataMongoProperties properties) {
            Assert.notNull((Object)mongoDatabaseFactory, (String)"'mongoDatabaseFactory' must not be null");
            Assert.notNull((Object)properties, (String)"'properties' must not be null");
            this.mongoDatabaseFactory = mongoDatabaseFactory;
            this.properties = properties;
        }

        public MongoDatabase getMongoDatabase() throws DataAccessException {
            String gridFsDatabase = this.getGridFsDatabase();
            if (StringUtils.hasText((String)gridFsDatabase)) {
                return this.mongoDatabaseFactory.getMongoDatabase(gridFsDatabase);
            }
            return this.mongoDatabaseFactory.getMongoDatabase();
        }

        public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
            return this.mongoDatabaseFactory.getMongoDatabase(dbName);
        }

        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.mongoDatabaseFactory.getExceptionTranslator();
        }

        public ClientSession getSession(ClientSessionOptions options) {
            return this.mongoDatabaseFactory.getSession(options);
        }

        public MongoDatabaseFactory withSession(ClientSession session) {
            return this.mongoDatabaseFactory.withSession(session);
        }

        private @Nullable String getGridFsDatabase() {
            return this.properties.getGridfs().getDatabase();
        }
    }
}

