/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;

class DefaultClientHttpMessageConvertersCustomizer
implements ClientHttpMessageConvertersCustomizer {
    private final @Nullable HttpMessageConverters legacyConverters;
    private final Collection<HttpMessageConverter<?>> converters;

    DefaultClientHttpMessageConvertersCustomizer(@Nullable HttpMessageConverters legacyConverters, Collection<HttpMessageConverter<?>> converters) {
        this.legacyConverters = legacyConverters;
        this.converters = converters;
    }

    @Override
    public void customize(HttpMessageConverters.ClientBuilder builder) {
        if (this.legacyConverters != null) {
            this.legacyConverters.forEach(arg_0 -> ((HttpMessageConverters.ClientBuilder)builder).customMessageConverter(arg_0));
        } else {
            builder.registerDefaults();
            this.converters.forEach(converter -> {
                if (converter instanceof StringHttpMessageConverter) {
                    builder.stringMessageConverter(converter);
                } else if (converter instanceof KotlinSerializationJsonHttpMessageConverter) {
                    builder.customMessageConverter(converter);
                } else if (converter.getSupportedMediaTypes().contains(MediaType.APPLICATION_JSON)) {
                    builder.jsonMessageConverter(converter);
                } else {
                    builder.customMessageConverter(converter);
                }
            });
        }
    }
}

