/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import com.google.gson.Gson;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.Jackson2HttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.GsonHttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Gson.class})
class GsonHttpMessageConvertersConfiguration {
    GsonHttpMessageConvertersConfiguration() {
    }

    private static class JacksonAndJsonbUnavailableCondition
    extends NoneNestedConditions {
        JacksonAndJsonbUnavailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jsonb")
        static class JsonbPreferred {
            JsonbPreferred() {
            }
        }

        @ConditionalOnBean(value={Jackson2HttpMessageConvertersConfiguration.Jackson2JsonMessageConvertersCustomizer.class})
        static class Jackson2Available {
            Jackson2Available() {
            }
        }

        @ConditionalOnBean(value={JacksonHttpMessageConvertersConfiguration.JacksonJsonHttpMessageConvertersCustomizer.class})
        static class JacksonAvailable {
            JacksonAvailable() {
            }
        }
    }

    private static class PreferGsonOrJacksonAndJsonbUnavailableCondition
    extends AnyNestedCondition {
        PreferGsonOrJacksonAndJsonbUnavailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={JacksonAndJsonbUnavailableCondition.class})
        static class JacksonJsonbUnavailable {
            JacksonJsonbUnavailable() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson")
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    static class GsonHttpConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final GsonHttpMessageConverter converter;

        GsonHttpConvertersCustomizer(Gson gson) {
            this.converter = new GsonHttpMessageConverter(gson);
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)this.converter);
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)this.converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrJacksonAndJsonbUnavailableCondition.class})
    static class GsonHttpMessageConverterConfiguration {
        GsonHttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={GsonHttpMessageConverter.class})
        GsonHttpConvertersCustomizer gsonHttpMessageConvertersCustomizer(Gson gson) {
            return new GsonHttpConvertersCustomizer(gson);
        }
    }
}

