/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactFeatureFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.springframework.boot.maven.Exclude;
import org.springframework.boot.maven.ExcludeFilter;
import org.springframework.boot.maven.Include;
import org.springframework.boot.maven.IncludeFilter;
import org.springframework.boot.maven.JarTypeFilter;
import org.springframework.boot.maven.MatchingGroupIdFilter;

public abstract class AbstractDependencyFilterMojo
extends AbstractMojo {
    static final ExcludeFilter DEVTOOLS_EXCLUDE_FILTER;
    static final ExcludeFilter DOCKER_COMPOSE_EXCLUDE_FILTER;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="spring-boot.includes")
    private List<Include> includes;
    @Parameter(property="spring-boot.excludes")
    private List<Exclude> excludes;
    @Parameter(property="spring-boot.excludeGroupIds", defaultValue="")
    private String excludeGroupIds;

    protected void setExcludes(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    protected void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    protected void setExcludeGroupIds(String excludeGroupIds) {
        this.excludeGroupIds = excludeGroupIds;
    }

    protected List<URL> getDependencyURLs(ArtifactsFilter ... additionalFilters) throws MojoExecutionException {
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), additionalFilters);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(this.toURL(artifact.getFile()));
        }
        return urls;
    }

    protected final Set<Artifact> filterDependencies(Set<Artifact> dependencies, ArtifactsFilter ... additionalFilters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(this.getFilters(additionalFilters).filter(dependencies));
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid URL for " + String.valueOf(file), ex);
        }
    }

    private FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        filters.addFilter((ArtifactsFilter)new MatchingGroupIdFilter(this.cleanFilterConfig(this.excludeGroupIds)));
        if (this.includes != null && !this.includes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        }
        filters.addFilter((ArtifactsFilter)new JarTypeFilter());
        return filters;
    }

    private String cleanFilterConfig(String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        StringBuilder cleaned = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            cleaned.append(tokenizer.nextToken().trim());
            if (!tokenizer.hasMoreElements()) continue;
            cleaned.append(",");
        }
        return cleaned.toString();
    }

    static {
        Exclude exclude = new Exclude();
        exclude.setGroupId("org.springframework.boot");
        exclude.setArtifactId("spring-boot-devtools");
        DEVTOOLS_EXCLUDE_FILTER = new ExcludeFilter(exclude);
        exclude = new Exclude();
        exclude.setGroupId("org.springframework.boot");
        exclude.setArtifactId("spring-boot-docker-compose");
        DOCKER_COMPOSE_EXCLUDE_FILTER = new ExcludeFilter(exclude);
    }

    protected static class ExcludeTestScopeArtifactFilter
    extends AbstractArtifactFeatureFilter {
        ExcludeTestScopeArtifactFilter() {
            super("", "test");
        }

        protected String getArtifactFeature(Artifact artifact) {
            return artifact.getScope();
        }
    }
}

