/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.graphite.GraphiteProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.graphite.GraphitePropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={GraphiteMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="graphite")
@EnableConfigurationProperties(value={GraphiteProperties.class})
public final class GraphiteMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    GraphiteConfig graphiteConfig(GraphiteProperties graphiteProperties) {
        return new GraphitePropertiesConfigAdapter(graphiteProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig graphiteConfig, Clock clock) {
        return new GraphiteMeterRegistry(graphiteConfig, clock);
    }
}

