/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.imperative.ImperativeHttpClientAutoConfiguration;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.AutoConfiguredRestClientSsl;
import org.springframework.boot.restclient.autoconfigure.HttpMessageConvertersRestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.RestClientBuilderConfigurer;
import org.springframework.boot.restclient.autoconfigure.RestClientSsl;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={ImperativeHttpClientAutoConfiguration.class, TaskExecutionAutoConfiguration.class, SslAutoConfiguration.class})
@ConditionalOnClass(value={RestClient.class})
public final class RestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RestClientSsl.class})
    @ConditionalOnBean(value={SslBundles.class})
    AutoConfiguredRestClientSsl restClientSsl(ResourceLoader resourceLoader, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<HttpClientSettings> httpClientSettings, SslBundles sslBundles) {
        ClassLoader classLoader = resourceLoader.getClassLoader();
        return new AutoConfiguredRestClientSsl((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(() -> ClientHttpRequestFactoryBuilder.detect((ClassLoader)classLoader)), (HttpClientSettings)httpClientSettings.getIfAvailable(HttpClientSettings::defaults), sslBundles);
    }

    @Bean
    @ConditionalOnMissingBean
    RestClientBuilderConfigurer restClientBuilderConfigurer(ResourceLoader resourceLoader, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<HttpClientSettings> httpClientSettings, ObjectProvider<RestClientCustomizer> customizerProvider) {
        return new RestClientBuilderConfigurer((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(() -> ClientHttpRequestFactoryBuilder.detect((ClassLoader)resourceLoader.getClassLoader())), (HttpClientSettings)httpClientSettings.getIfAvailable(HttpClientSettings::defaults), customizerProvider.orderedStream().toList());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    RestClient.Builder restClientBuilder(RestClientBuilderConfigurer restClientBuilderConfigurer) {
        return restClientBuilderConfigurer.configure(RestClient.builder());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpMessageConverters.class})
    static class HttpMessageConvertersConfiguration {
        HttpMessageConvertersConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ClientHttpMessageConvertersCustomizer.class})
        @Order(value=0x7FFFFFFF)
        HttpMessageConvertersRestClientCustomizer httpMessageConvertersRestClientCustomizer(ObjectProvider<ClientHttpMessageConvertersCustomizer> customizerProvider) {
            return new HttpMessageConvertersRestClientCustomizer(customizerProvider.orderedStream().toList());
        }
    }
}

