/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenTelemetryLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OtlpLoggingConnectionDetails> {
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryLoggingContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", "org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingAutoConfiguration");
    }

    @Override
    protected OtlpLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenTelemetryLoggingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OtlpLoggingConnectionDetails {
        private OpenTelemetryLoggingContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> 4318;
                case Transport.GRPC -> 4317;
            };
            return "http://%s:%d/v1/logs".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(port));
        }
    }
}

