/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.reactive.context;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.ApplicationContext;

class ReactiveWebServerApplicationContextLocalTestWebServerProvider
implements LocalTestWebServer.Provider {
    private final @Nullable ReactiveWebServerApplicationContext context;

    ReactiveWebServerApplicationContextLocalTestWebServerProvider(ApplicationContext context) {
        this.context = ReactiveWebServerApplicationContextLocalTestWebServerProvider.getWebServerApplicationContextIfPossible(context);
    }

    static @Nullable ReactiveWebServerApplicationContext getWebServerApplicationContextIfPossible(ApplicationContext context) {
        try {
            return (ReactiveWebServerApplicationContext)context;
        }
        catch (ClassCastException | NoClassDefFoundError ex) {
            return null;
        }
    }

    public @Nullable LocalTestWebServer getLocalTestWebServer() {
        if (this.context == null) {
            return null;
        }
        return LocalTestWebServer.of((LocalTestWebServer.Scheme)(this.isSslEnabled(this.context) ? LocalTestWebServer.Scheme.HTTPS : LocalTestWebServer.Scheme.HTTP), () -> {
            int port = (Integer)this.context.getEnvironment().getProperty("local.server.port", Integer.class, (Object)8080);
            String path = this.context.getEnvironment().getProperty("spring.webflux.base-path", "");
            return new LocalTestWebServer.BaseUriDetails(port, path);
        });
    }

    private boolean isSslEnabled(ReactiveWebServerApplicationContext context) {
        try {
            AbstractConfigurableWebServerFactory webServerFactory = (AbstractConfigurableWebServerFactory)context.getBean(AbstractConfigurableWebServerFactory.class);
            return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }
}

