/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.ApiversionProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsPropertyMapper;
import org.springframework.boot.http.client.autoconfigure.PropertiesApiVersionInserter;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class PropertiesWebClientHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer {
    private final HttpServiceClientProperties properties;
    private final HttpClientSettingsPropertyMapper clientSettingsPropertyMapper;
    private final ClientHttpConnectorBuilder<?> clientConnectorBuilder;

    PropertiesWebClientHttpServiceGroupConfigurer(@Nullable ClassLoader classLoader, HttpServiceClientProperties properties, @Nullable SslBundles sslBundles, ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder, @Nullable HttpClientSettings httpClientSettings) {
        this.properties = properties;
        this.clientSettingsPropertyMapper = new HttpClientSettingsPropertyMapper(sslBundles, httpClientSettings);
        this.clientConnectorBuilder = (ClientHttpConnectorBuilder)clientConnectorBuilder.getIfAvailable(() -> ClientHttpConnectorBuilder.detect((ClassLoader)classLoader));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, WebClient.Builder builder) {
        HttpClientProperties clientProperties = this.properties.get(group.name());
        HttpClientSettings clientSettings = this.clientSettingsPropertyMapper.map((HttpClientSettingsProperties)clientProperties);
        builder.clientConnector(this.clientConnectorBuilder.build(clientSettings));
        if (clientProperties != null) {
            PropertyMapper map = PropertyMapper.get();
            map.from(() -> ((HttpClientProperties)clientProperties).getBaseUrl()).whenHasText().to(arg_0 -> ((WebClient.Builder)builder).baseUrl(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getDefaultHeader()).as(this::putAllHeaders).to(arg_0 -> ((WebClient.Builder)builder).defaultHeaders(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getApiversion()).as(ApiversionProperties::getDefaultVersion).to(arg_0 -> ((WebClient.Builder)builder).defaultApiVersion(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getApiversion()).as(ApiversionProperties::getInsert).as(PropertiesApiVersionInserter::get).to(arg_0 -> ((WebClient.Builder)builder).apiVersionInserter(arg_0));
        }
    }

    private Consumer<HttpHeaders> putAllHeaders(Map<String, List<String>> defaultHeaders) {
        return httpHeaders -> httpHeaders.putAll(defaultHeaders);
    }
}

