/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.MaximumAllowableTagsMeterFilter;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration", "org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnClass(value={Observation.class, MeterRegistry.class})
@ConditionalOnBean(value={ObservationRegistry.class, MeterRegistry.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public final class WebFluxObservationAutoConfiguration {
    private final ObservationProperties observationProperties;

    WebFluxObservationAutoConfiguration(ObservationProperties observationProperties) {
        this.observationProperties = observationProperties;
    }

    @Bean
    @Order(value=0)
    MaximumAllowableTagsMeterFilter metricsHttpServerUriTagFilter(MetricsProperties metricsProperties) {
        String meterNamePrefix = this.observationProperties.getHttp().getServer().getRequests().getName();
        int maxUriTags = metricsProperties.getWeb().getServer().getMaxUriTags();
        return new MaximumAllowableTagsMeterFilter(meterNamePrefix, "uri", maxUriTags);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerRequestObservationConvention.class})
    DefaultServerRequestObservationConvention defaultServerRequestObservationConvention() {
        return new DefaultServerRequestObservationConvention(this.observationProperties.getHttp().getServer().getRequests().getName());
    }
}

