/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class BusEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String DEFAULTS_PROPERTY_SOURCE_NAME = "springCloudBusDefaultProperties";
    static final String OVERRIDES_PROPERTY_SOURCE_NAME = "springCloudBusOverridesProperties";
    private static final String FN_DEF_PROP = "spring.cloud.function.definition";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.containsProperty("spring.cloud.bus.enabled") && Boolean.FALSE.toString().equalsIgnoreCase(environment.getProperty("spring.cloud.bus.enabled"))) {
            return;
        }
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        Object definition = "busConsumer";
        if (environment.containsProperty(FN_DEF_PROP)) {
            String property = environment.getProperty(FN_DEF_PROP);
            if (property != null && property.contains("busConsumer")) {
                return;
            }
            definition = property + ";" + (String)definition;
        }
        overrides.put(FN_DEF_PROP, definition);
        BusEnvironmentPostProcessor.addOrReplace(environment.getPropertySources(), overrides, OVERRIDES_PROPERTY_SOURCE_NAME, true);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("spring.cloud.stream.function.bindings.busConsumer-in-0", "springCloudBusInput");
        String destination = environment.getProperty("spring.cloud.bus.destination", "springCloudBus");
        defaults.put("spring.cloud.stream.bindings.springCloudBusInput.destination", destination);
        defaults.put("spring.cloud.stream.bindings.springCloudBusOutput.destination", destination);
        if (!environment.containsProperty("spring.cloud.bus.id")) {
            String unresolvedServiceId = IdUtils.getUnresolvedServiceId();
            if (StringUtils.hasText((String)environment.getProperty("spring.profiles.active"))) {
                unresolvedServiceId = IdUtils.getUnresolvedServiceIdWithActiveProfiles();
            }
            defaults.put("spring.cloud.bus.id", unresolvedServiceId);
        }
        BusEnvironmentPostProcessor.addOrReplace(environment.getPropertySources(), defaults, DEFAULTS_PROPERTY_SOURCE_NAME, false);
    }

    public static void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map, String propertySourceName, boolean first) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(propertySourceName) && (source = propertySources.get(propertySourceName)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(propertySourceName, map);
        }
        if (!propertySources.contains(propertySourceName)) {
            if (first) {
                propertySources.addFirst((PropertySource)target);
            } else {
                propertySources.addLast((PropertySource)target);
            }
        }
    }
}

