/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.net.URI;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public interface ServiceInstance {
    default public @Nullable String getInstanceId() {
        return null;
    }

    public String getServiceId();

    public String getHost();

    public int getPort();

    public boolean isSecure();

    public URI getUri();

    public @Nullable Map<String, String> getMetadata();

    default public @Nullable String getScheme() {
        return null;
    }

    public static URI createUri(ServiceInstance instance) {
        String scheme = instance.isSecure() ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = instance.isSecure() ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getHost(), port);
        return URI.create(uri);
    }
}

