/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.cloud.config.client.ConfigClientHealthProperties;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class ConfigServerHealthIndicator
extends AbstractHealthIndicator {
    private ConfigClientHealthProperties properties;
    private ConfigurableEnvironment environment;
    private long lastAccess = 0L;
    private List<PropertySource<?>> cached = new ArrayList();

    public ConfigServerHealthIndicator(ConfigurableEnvironment environment, ConfigClientHealthProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) {
        List<PropertySource<?>> propertySources = this.getPropertySource();
        if (propertySources.isEmpty()) {
            builder.unknown();
            builder.unknown().withDetail("error", (Object)"no property sources located");
        } else {
            builder.up();
            ArrayList<String> sources = new ArrayList<String>();
            for (PropertySource<?> propertySource : propertySources) {
                if (propertySource instanceof CompositePropertySource) {
                    for (PropertySource ps : ((CompositePropertySource)propertySource).getPropertySources()) {
                        sources.add(ps.getName());
                    }
                    continue;
                }
                if (propertySource == null) continue;
                sources.add(propertySource.getName());
            }
            builder.withDetail("propertySources", sources);
        }
    }

    private List<PropertySource<?>> getPropertySource() {
        long accessTime = System.currentTimeMillis();
        if (this.isCacheStale(accessTime)) {
            this.lastAccess = accessTime;
            this.cached = this.environment.getPropertySources().stream().filter(p -> p.getName().startsWith("configClient") || p.getName().startsWith("bootstrapProperties-") || p.getName().startsWith("configserver:")).collect(Collectors.toList());
        }
        return this.cached;
    }

    private boolean isCacheStale(long accessTime) {
        if (this.cached == null) {
            return true;
        }
        return accessTime - this.lastAccess >= this.properties.getTimeToLive().toMillis();
    }
}

