/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.BootstrapRegistryInitializer;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.config.ConsulConfigDataResource;
import org.springframework.util.Assert;

public class ConsulBootstrapper
implements BootstrapRegistryInitializer {
    private Function<BootstrapContext, ConsulClient> consulClientFactory;
    private LoaderInterceptor loaderInterceptor;

    static BootstrapRegistryInitializer fromConsulProperties(Function<ConsulProperties, ConsulClient> factory) {
        return registry -> registry.register(ConsulClient.class, context -> {
            ConsulProperties properties = (ConsulProperties)context.get(ConsulProperties.class);
            return (ConsulClient)factory.apply(properties);
        });
    }

    static BootstrapRegistryInitializer fromBootstrapContext(Function<BootstrapContext, ConsulClient> factory) {
        return registry -> registry.register(ConsulClient.class, factory::apply);
    }

    static ConsulBootstrapper create() {
        return new ConsulBootstrapper();
    }

    public ConsulBootstrapper withConsulClientFactory(Function<BootstrapContext, ConsulClient> consulClientFactory) {
        this.consulClientFactory = consulClientFactory;
        return this;
    }

    public ConsulBootstrapper withLoaderInterceptor(LoaderInterceptor loaderInterceptor) {
        this.loaderInterceptor = loaderInterceptor;
        return this;
    }

    public void initialize(BootstrapRegistry registry) {
        if (this.consulClientFactory != null) {
            registry.register(ConsulClient.class, this.consulClientFactory::apply);
        }
        if (this.loaderInterceptor != null) {
            registry.register(LoaderInterceptor.class, BootstrapRegistry.InstanceSupplier.of((Object)this.loaderInterceptor));
        }
    }

    public static interface LoaderInterceptor
    extends Function<LoadContext, ConfigData> {
    }

    public static class LoadContext {
        private final ConfigDataLoaderContext loaderContext;
        private final ConsulConfigDataResource resource;
        private final Binder binder;
        private final LoaderInvocation invocation;

        LoadContext(ConfigDataLoaderContext loaderContext, ConsulConfigDataResource resource, Binder binder, LoaderInvocation invocation) {
            Assert.notNull((Object)loaderContext, (String)"loaderContext may not be null");
            Assert.notNull((Object)((Object)resource), (String)"resource may not be null");
            Assert.notNull((Object)binder, (String)"binder may not be null");
            Assert.notNull((Object)invocation, (String)"invocation may not be null");
            this.loaderContext = loaderContext;
            this.resource = resource;
            this.binder = binder;
            this.invocation = invocation;
        }

        public ConfigDataLoaderContext getLoaderContext() {
            return this.loaderContext;
        }

        public ConsulConfigDataResource getResource() {
            return this.resource;
        }

        public Binder getBinder() {
            return this.binder;
        }

        public LoaderInvocation getInvocation() {
            return this.invocation;
        }
    }

    @FunctionalInterface
    public static interface LoaderInvocation
    extends BiFunction<ConfigDataLoaderContext, ConsulConfigDataResource, ConfigData> {
    }
}

