/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.health.contributor.Status;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.model.http.agent.NewService;
import org.springframework.cloud.consul.model.http.health.Check;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.core.log.LogMessage;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;

public class ConsulServiceRegistry
implements ServiceRegistry<ConsulRegistration> {
    private static Log log = LogFactory.getLog(ConsulServiceRegistry.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private final TtlScheduler ttlScheduler;
    private final HeartbeatProperties heartbeatProperties;

    public ConsulServiceRegistry(ConsulClient client, ConsulDiscoveryProperties properties, TtlScheduler ttlScheduler, HeartbeatProperties heartbeatProperties) {
        this.client = client;
        this.properties = properties;
        this.ttlScheduler = ttlScheduler;
        this.heartbeatProperties = heartbeatProperties;
    }

    public void register(ConsulRegistration reg) {
        log.info((Object)("Registering service with consul: " + String.valueOf(reg.getService())));
        try {
            ResponseEntity response = this.client.agentServiceRegister(this.properties.getAclToken(), reg.getService());
            NewService service = reg.getService();
            if (this.heartbeatProperties.isEnabled() && this.ttlScheduler != null && service.getCheck() != null && service.getCheck().getTtl() != null) {
                this.ttlScheduler.add(reg.getService());
            }
        }
        catch (RuntimeException e) {
            if (this.properties.isFailFast()) {
                log.error((Object)("Error registering service with consul: " + String.valueOf(reg.getService())), (Throwable)e);
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            log.warn((Object)("Failfast is false. Error registering service with consul: " + String.valueOf(reg.getService())), (Throwable)e);
        }
    }

    public void deregister(ConsulRegistration reg) {
        if (this.ttlScheduler != null) {
            this.ttlScheduler.remove(reg.getInstanceId());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Deregistering service with consul: " + reg.getInstanceId()));
        }
        this.client.agentServiceDeregister(reg.getInstanceId(), this.properties.getAclToken());
    }

    public void close() {
    }

    public void setStatus(ConsulRegistration registration, String status) {
        if (status.equalsIgnoreCase(Status.OUT_OF_SERVICE.getCode())) {
            ResponseEntity response = this.client.agentServiceSetMaintenance(registration.getInstanceId(), Boolean.valueOf(true), null, this.properties.getAclToken());
            log.debug((Object)LogMessage.format((String)("Set status for service with consul: %s, status %s, response %s" + registration.getInstanceId()), (Object)status, (Object)response));
        } else if (status.equalsIgnoreCase(Status.UP.getCode())) {
            ResponseEntity response = this.client.agentServiceSetMaintenance(registration.getInstanceId(), Boolean.valueOf(false), null, this.properties.getAclToken());
            log.debug((Object)LogMessage.format((String)("Set status for service with consul: %s, status %s, response %s" + registration.getInstanceId()), (Object)status, (Object)response));
        } else {
            throw new IllegalArgumentException("Unknown status: " + status);
        }
    }

    public Object getStatus(ConsulRegistration registration) {
        String serviceId = registration.getServiceId();
        ResponseEntity response = this.client.getHealthChecksForService(serviceId);
        List checks = (List)response.getBody();
        for (Check check : checks) {
            if (!check.getServiceId().equals(registration.getInstanceId()) || !check.getName().equalsIgnoreCase("Service Maintenance Mode")) continue;
            return Status.OUT_OF_SERVICE.getCode();
        }
        return Status.UP.getCode();
    }
}

