/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NamespaceResolutionFailedException;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;

@Order(value=0)
public class KubernetesClientConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final CoreV1Api coreV1Api;
    private final KubernetesClientProperties kubernetesClientProperties;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    @Deprecated
    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesClientProperties kubernetesClientProperties) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
        this.kubernetesNamespaceProvider = null;
    }

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
        this.kubernetesClientProperties = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MapPropertySource getMapPropertySource(String name, ConfigMapConfigProperties.NormalizedSource normalizedSource, String configurationTarget, ConfigurableEnvironment environment) {
        String namespace;
        String normalizedNamespace = normalizedSource.getNamespace();
        if (StringUtils.hasText((String)normalizedNamespace)) {
            namespace = normalizedNamespace;
            return new KubernetesClientConfigMapPropertySource(this.coreV1Api, name, namespace, (Environment)environment, normalizedSource.getPrefix(), normalizedSource.isIncludeProfileSpecificSources(), this.properties.isFailFast());
        } else if (this.kubernetesClientProperties != null) {
            if (!StringUtils.hasText((String)this.kubernetesClientProperties.getNamespace())) throw new NamespaceResolutionFailedException("could not resolve namespace in normalized source or KubernetesClientProperties");
            namespace = this.kubernetesClientProperties.getNamespace();
            return new KubernetesClientConfigMapPropertySource(this.coreV1Api, name, namespace, (Environment)environment, normalizedSource.getPrefix(), normalizedSource.isIncludeProfileSpecificSources(), this.properties.isFailFast());
        } else {
            namespace = KubernetesClientConfigUtils.getApplicationNamespace(normalizedNamespace, "Config Map", this.kubernetesNamespaceProvider);
        }
        return new KubernetesClientConfigMapPropertySource(this.coreV1Api, name, namespace, (Environment)environment, normalizedSource.getPrefix(), normalizedSource.isIncludeProfileSpecificSources(), this.properties.isFailFast());
    }
}

