/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.loadbalancer.core.BlockingApiVersionServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.HealthCheckServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.HintBasedServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactiveApiVersionServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RequestBasedStickySessionServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RetryAwareServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.SameInstancePreferenceServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.SubsetServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.WeightFunction;
import org.springframework.cloud.loadbalancer.core.WeightedServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ZonePreferenceServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ServiceInstanceListSupplierBuilder {
    private static final Log LOG = LogFactory.getLog(ServiceInstanceListSupplierBuilder.class);
    private @Nullable Creator baseCreator;
    private final List<DelegateCreator> creators = new ArrayList<DelegateCreator>();

    ServiceInstanceListSupplierBuilder() {
    }

    public ServiceInstanceListSupplierBuilder withBlockingDiscoveryClient() {
        if (this.baseCreator != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Overriding a previously set baseCreator with a blocking DiscoveryClient baseCreator.");
        }
        this.baseCreator = context -> {
            DiscoveryClient discoveryClient = (DiscoveryClient)context.getBean(DiscoveryClient.class);
            return new DiscoveryClientServiceInstanceListSupplier(discoveryClient, (Environment)context.getEnvironment());
        };
        return this;
    }

    public ServiceInstanceListSupplierBuilder withDiscoveryClient() {
        if (this.baseCreator != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Overriding a previously set baseCreator with a ReactiveDiscoveryClient baseCreator.");
        }
        this.baseCreator = context -> {
            ReactiveDiscoveryClient discoveryClient = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            return new DiscoveryClientServiceInstanceListSupplier(discoveryClient, (Environment)context.getEnvironment());
        };
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBase(ServiceInstanceListSupplier supplier) {
        this.baseCreator = context -> supplier;
        return this;
    }

    public ServiceInstanceListSupplierBuilder withWeighted() {
        DelegateCreator creator = (context, delegate) -> {
            ReactiveLoadBalancer.Factory loadBalancerClientFactory = (ReactiveLoadBalancer.Factory)context.getBean(LoadBalancerClientFactory.class);
            return new WeightedServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withWeighted(WeightFunction weightFunction) {
        DelegateCreator creator = (context, delegate) -> {
            ReactiveLoadBalancer.Factory loadBalancerClientFactory = (ReactiveLoadBalancer.Factory)context.getBean(LoadBalancerClientFactory.class);
            return new WeightedServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, weightFunction, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withHealthChecks() {
        DelegateCreator creator = (context, delegate) -> {
            ReactiveLoadBalancer.Factory loadBalancerClientFactory = (ReactiveLoadBalancer.Factory)context.getBean(LoadBalancerClientFactory.class);
            WebClient.Builder webClient = (WebClient.Builder)context.getBean(WebClient.Builder.class);
            return this.healthCheckServiceInstanceListSupplier(webClient.build(), (ServiceInstanceListSupplier)delegate, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withHealthChecks(WebClient webClient) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return this.healthCheckServiceInstanceListSupplier(webClient, (ServiceInstanceListSupplier)delegate, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withSameInstancePreference() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new SameInstancePreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingHealthChecks() {
        DelegateCreator creator = (context, delegate) -> {
            RestTemplate restTemplate = (RestTemplate)context.getBean(RestTemplate.class);
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return this.blockingHealthCheckServiceInstanceListSupplier(restTemplate, (ServiceInstanceListSupplier)delegate, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingRestClientHealthChecks() {
        DelegateCreator creator = (context, delegate) -> {
            RestClient restClient = (RestClient)context.getBean(RestClient.class);
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return this.blockingHealthCheckServiceInstanceListSupplier(restClient, (ServiceInstanceListSupplier)delegate, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingHealthChecks(RestTemplate restTemplate) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return this.blockingHealthCheckServiceInstanceListSupplier(restTemplate, (ServiceInstanceListSupplier)delegate, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingHealthChecks(RestClient restClient) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return this.blockingHealthCheckServiceInstanceListSupplier(restClient, (ServiceInstanceListSupplier)delegate, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withZonePreference() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            LoadBalancerZoneConfig zoneConfig = (LoadBalancerZoneConfig)context.getBean(LoadBalancerZoneConfig.class);
            return new ZonePreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, zoneConfig, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withZonePreference(String zoneName) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            LoadBalancerZoneConfig zoneConfig = new LoadBalancerZoneConfig(zoneName);
            return new ZonePreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, zoneConfig, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withRequestBasedStickySession() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory loadBalancerClientFactory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new RequestBasedStickySessionServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, loadBalancerClientFactory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withCaching() {
        DelegateCreator creator = (context, delegate) -> {
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"LoadBalancerCacheManager not available, returning delegate without caching.");
            }
            return delegate;
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withRetryAwareness() {
        DelegateCreator creator = (context, delegate) -> new RetryAwareServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate);
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withHints() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory factory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new HintBasedServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, factory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withSubset() {
        DelegateCreator creator = (context, delegate) -> {
            PropertyResolver resolver = (PropertyResolver)context.getBean(PropertyResolver.class);
            LoadBalancerClientFactory factory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new SubsetServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, resolver, factory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withReactiveApiVersioning() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory factory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new ReactiveApiVersionServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, factory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingApiVersioning() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerClientFactory factory = (LoadBalancerClientFactory)((Object)((Object)context.getBean(LoadBalancerClientFactory.class)));
            return new BlockingApiVersionServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, factory);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder with(@Nullable DelegateCreator delegateCreator) {
        if (delegateCreator != null) {
            this.creators.add(delegateCreator);
        }
        return this;
    }

    public ServiceInstanceListSupplier build(ConfigurableApplicationContext context) {
        Assert.notNull((Object)this.baseCreator, (String)"A baseCreator must not be null");
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.baseCreator.apply(context);
        for (DelegateCreator creator : this.creators) {
            supplier = (ServiceInstanceListSupplier)creator.apply(context, supplier);
        }
        return supplier;
    }

    private ServiceInstanceListSupplier healthCheckServiceInstanceListSupplier(WebClient webClient, ServiceInstanceListSupplier delegate, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        return new HealthCheckServiceInstanceListSupplier(delegate, loadBalancerClientFactory, (serviceInstance, healthCheckPath) -> webClient.get().uri(UriComponentsBuilder.fromUriString((String)ServiceInstanceListSupplierBuilder.getUri(serviceInstance, healthCheckPath)).build().toUri()).retrieve().toBodilessEntity().map(response -> HttpStatus.OK.equals((Object)response.getStatusCode())).onErrorReturn((Object)false));
    }

    private ServiceInstanceListSupplier blockingHealthCheckServiceInstanceListSupplier(RestTemplate restTemplate, ServiceInstanceListSupplier delegate, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        return new HealthCheckServiceInstanceListSupplier(delegate, loadBalancerClientFactory, (serviceInstance, healthCheckPath) -> Mono.defer(() -> {
            URI uri = UriComponentsBuilder.fromUriString((String)ServiceInstanceListSupplierBuilder.getUri(serviceInstance, healthCheckPath)).build().toUri();
            try {
                return Mono.just((Object)HttpStatus.OK.equals((Object)restTemplate.getForEntity(uri, Void.class).getStatusCode()));
            }
            catch (Exception ignored) {
                return Mono.just((Object)false);
            }
        }));
    }

    private ServiceInstanceListSupplier blockingHealthCheckServiceInstanceListSupplier(RestClient restClient, ServiceInstanceListSupplier delegate, LoadBalancerClientFactory loadBalancerClientFactory) {
        return new HealthCheckServiceInstanceListSupplier(delegate, loadBalancerClientFactory, (serviceInstance, healthCheckPath) -> Mono.defer(() -> {
            URI uri = UriComponentsBuilder.fromUriString((String)ServiceInstanceListSupplierBuilder.getUri(serviceInstance, healthCheckPath)).build().toUri();
            try {
                return Mono.just((Object)HttpStatus.OK.equals((Object)restClient.get().uri(uri).retrieve().toBodilessEntity().getStatusCode()));
            }
            catch (Exception ignored) {
                return Mono.just((Object)false);
            }
        }));
    }

    static String getUri(ServiceInstance serviceInstance, String healthCheckPath) {
        if (StringUtils.hasText((String)healthCheckPath)) {
            Object path = healthCheckPath.startsWith("/") ? healthCheckPath : "/" + healthCheckPath;
            return serviceInstance.getUri().toString() + (String)path;
        }
        return serviceInstance.getUri().toString();
    }

    public static interface Creator
    extends Function<ConfigurableApplicationContext, ServiceInstanceListSupplier> {
    }

    public static interface DelegateCreator
    extends BiFunction<ConfigurableApplicationContext, ServiceInstanceListSupplier, ServiceInstanceListSupplier> {
    }
}

