/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.data.mapping.FactoryMethod;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingInstantiationException
extends RuntimeException {
    private static final long serialVersionUID = 822211065035487628L;
    private static final String TEXT_TEMPLATE = "Failed to instantiate %s using constructor %s with arguments %s";
    private final @Nullable Class<?> entityType;
    private final @Nullable InstanceCreatorMetadata<?> entityCreator;
    private final List<Object> constructorArguments;

    public MappingInstantiationException(@Nullable PersistentEntity<?, ?> entity, List<Object> arguments, Exception cause) {
        this(entity, arguments, null, cause);
    }

    public MappingInstantiationException(List<Object> arguments, Exception cause) {
        this(null, arguments, null, cause);
    }

    private MappingInstantiationException(@Nullable PersistentEntity<?, ?> entity, List<Object> arguments, @Nullable String message, Exception cause) {
        super(MappingInstantiationException.buildExceptionMessage(entity, arguments, message), cause);
        this.entityType = entity != null ? entity.getType() : null;
        this.entityCreator = entity != null ? entity.getInstanceCreatorMetadata() : null;
        this.constructorArguments = arguments;
    }

    private static @Nullable String buildExceptionMessage(@Nullable PersistentEntity<?, ?> entity, List<Object> arguments, @Nullable String defaultMessage) {
        if (entity == null) {
            return defaultMessage;
        }
        InstanceCreatorMetadata<?> constructor = entity.getInstanceCreatorMetadata();
        ArrayList<String> toStringArgs = new ArrayList<String>(arguments.size());
        for (Object o : arguments) {
            toStringArgs.add(ObjectUtils.nullSafeToString((Object)o));
        }
        return String.format(TEXT_TEMPLATE, entity.getType().getName(), constructor != null ? MappingInstantiationException.toString(constructor) : "NO_CONSTRUCTOR", String.join((CharSequence)",", toStringArgs));
    }

    private static String toString(InstanceCreatorMetadata<?> creator) {
        if (creator instanceof PreferredConstructor) {
            PreferredConstructor c = (PreferredConstructor)creator;
            return MappingInstantiationException.toString(c);
        }
        if (creator instanceof FactoryMethod) {
            FactoryMethod m = (FactoryMethod)creator;
            return MappingInstantiationException.toString(m);
        }
        return creator.toString();
    }

    private static String toString(PreferredConstructor<?, ?> preferredConstructor) {
        KFunction kotlinFunction;
        Constructor<?> constructor = preferredConstructor.getConstructor();
        if (KotlinDetector.isKotlinPresent() && KotlinReflectionUtils.isSupportedKotlinClass(constructor.getDeclaringClass()) && (kotlinFunction = ReflectJvmMapping.getKotlinFunction(constructor)) != null) {
            return kotlinFunction.toString();
        }
        return constructor.toString();
    }

    private static String toString(FactoryMethod<?, ?> factoryMethod) {
        KFunction kotlinFunction;
        Method constructor = factoryMethod.getFactoryMethod();
        if (KotlinDetector.isKotlinPresent() && KotlinReflectionUtils.isSupportedKotlinClass(constructor.getDeclaringClass()) && (kotlinFunction = ReflectJvmMapping.getKotlinFunction((Method)constructor)) != null) {
            return kotlinFunction.toString();
        }
        return constructor.toString();
    }

    public @Nullable Class<?> getEntityType() {
        return this.entityType;
    }

    public @Nullable InstanceCreatorMetadata<?> getEntityCreator() {
        return this.entityCreator;
    }

    public List<Object> getConstructorArguments() {
        return this.constructorArguments;
    }
}

