/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.Set;
import org.springframework.data.repository.aot.generate.MethodMetadata;
import org.springframework.data.repository.aot.generate.VariableNameFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class LocalVariableNameFactory
implements VariableNameFactory {
    private final MultiValueMap<String, String> variables = new LinkedMultiValueMap();

    LocalVariableNameFactory(Iterable<String> predefinedVariableNames) {
        predefinedVariableNames.forEach(varName -> this.variables.add(varName, varName));
    }

    static LocalVariableNameFactory forMethod(MethodMetadata methodMetadata) {
        return LocalVariableNameFactory.of(methodMetadata.getMethodArguments().keySet());
    }

    static LocalVariableNameFactory of(Set<String> predefinedVariables) {
        return new LocalVariableNameFactory(predefinedVariables);
    }

    @Override
    public String generateName(String intendedVariableName) {
        if (!this.variables.containsKey((Object)intendedVariableName)) {
            this.variables.add((Object)intendedVariableName, (Object)intendedVariableName);
            return intendedVariableName;
        }
        String targetName = this.suggestTargetName(intendedVariableName);
        this.variables.add((Object)intendedVariableName, (Object)targetName);
        this.variables.add((Object)targetName, (Object)targetName);
        return targetName;
    }

    String suggestTargetName(String suggested) {
        return this.suggestTargetName(suggested, 1);
    }

    String suggestTargetName(String suggested, int counter) {
        String targetName = "%s_%s".formatted(suggested, counter);
        if (!this.variables.containsKey((Object)targetName)) {
            return targetName;
        }
        return this.suggestTargetName(suggested, counter + 1);
    }
}

