/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.util.Assert;

public interface EntityInformation<T, ID>
extends EntityMetadata<T> {
    public boolean isNew(T var1);

    public @Nullable ID getId(T var1);

    default public ID getRequiredId(T entity) throws IllegalArgumentException {
        Assert.notNull(entity, (String)"Entity must not be null");
        ID id = this.getId(entity);
        if (id != null) {
            return id;
        }
        throw new IllegalArgumentException(String.format("Could not obtain required identifier from entity %s", entity));
    }

    public Class<ID> getIdType();
}

