/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public interface RepositoryFragment<T> {
    public static <T> RepositoryFragment<T> implemented(T implementation) {
        return new ImplementedRepositoryFragment<T>(null, implementation);
    }

    public static <T> RepositoryFragment<T> implemented(Class<T> interfaceClass, T implementation) {
        return new ImplementedRepositoryFragment<T>(interfaceClass, implementation);
    }

    public static <T> RepositoryFragment<T> structural(Class<T> interfaceOrImplementation) {
        return new StructuralRepositoryFragment<T>(interfaceOrImplementation);
    }

    public static <T> RepositoryFragment<T> structural(Class<T> interfaceClass, Class<?> implementationClass) {
        return new StructuralRepositoryFragment<T>(interfaceClass, implementationClass);
    }

    default public boolean hasMethod(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        return ReflectionUtils.findMethod(this.getSignatureContributor(), (String)method.getName(), (Class[])method.getParameterTypes()) != null;
    }

    default public Optional<T> getImplementation() {
        return Optional.empty();
    }

    default public Optional<Class<?>> getImplementationClass() {
        return this.getImplementation().map(it -> it.getClass());
    }

    default public Stream<Method> methods() {
        return Arrays.stream(this.getSignatureContributor().getMethods());
    }

    public List<Method> findMethods(String var1);

    public Class<?> getSignatureContributor();

    public RepositoryFragment<T> withImplementation(T var1);

    private static List<Method> findMethods(String name, Method[] candidates) {
        Method firstMatch = null;
        for (Method method : candidates) {
            if (!method.getName().equals(name)) continue;
            if (firstMatch != null) {
                firstMatch = null;
                break;
            }
            firstMatch = method;
        }
        if (firstMatch != null) {
            return List.of(firstMatch);
        }
        ArrayList<Method> results = new ArrayList<Method>(candidates.length);
        for (Method method : candidates) {
            if (!method.getName().equals(name)) continue;
            results.add(method);
        }
        return results;
    }

    private static boolean hasMethod(Method method, Method[] candidates) {
        for (Method candidate : candidates) {
            if (!candidate.getName().equals(method.getName()) || candidate.getParameterCount() != method.getParameterCount() || !Arrays.equals(candidate.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    public static class ImplementedRepositoryFragment<T>
    implements RepositoryFragment<T> {
        private final @Nullable Class<T> interfaceClass;
        private final T implementation;
        private final Method[] methods;

        public ImplementedRepositoryFragment(@Nullable Class<T> interfaceClass, T implementation) {
            Assert.notNull(implementation, (String)"Implementation object must not be null");
            if (interfaceClass != null && !(implementation instanceof Class)) {
                Assert.isTrue((boolean)ClassUtils.isAssignableValue(interfaceClass, implementation), () -> "Fragment implementation %s does not implement %s".formatted(ClassUtils.getQualifiedName(implementation.getClass()), ClassUtils.getQualifiedName((Class)interfaceClass)));
            }
            this.interfaceClass = interfaceClass;
            this.implementation = implementation;
            this.methods = this.getSignatureContributor().getMethods();
        }

        @Override
        public Class<?> getSignatureContributor() {
            if (this.interfaceClass != null) {
                return this.interfaceClass;
            }
            T t = this.implementation;
            if (t instanceof Class) {
                Class type = (Class)t;
                return type;
            }
            return this.implementation.getClass();
        }

        @Override
        public Stream<Method> methods() {
            return Arrays.stream(this.methods);
        }

        @Override
        public List<Method> findMethods(String name) {
            return RepositoryFragment.findMethods(name, this.methods);
        }

        @Override
        public boolean hasMethod(Method method) {
            if (RepositoryFragment.hasMethod(method, this.methods)) {
                return true;
            }
            return RepositoryFragment.super.hasMethod(method);
        }

        @Override
        public Optional<T> getImplementation() {
            return Optional.of(this.implementation);
        }

        @Override
        public RepositoryFragment<T> withImplementation(T implementation) {
            return new ImplementedRepositoryFragment<T>(this.interfaceClass, implementation);
        }

        public String toString() {
            return String.format("ImplementedRepositoryFragment %s%s", this.interfaceClass != null ? ClassUtils.getShortName(this.interfaceClass) + ":" : "", ClassUtils.getShortName(this.implementation.getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImplementedRepositoryFragment)) {
                return false;
            }
            ImplementedRepositoryFragment that = (ImplementedRepositoryFragment)o;
            if (!ObjectUtils.nullSafeEquals(this.interfaceClass, that.interfaceClass)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.implementation, that.implementation);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.interfaceClass);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.implementation);
            return result;
        }
    }

    public static class StructuralRepositoryFragment<T>
    implements RepositoryFragment<T> {
        private final Class<T> interfaceClass;
        private final Class<?> implementationClass;
        private final Method[] methods;

        public StructuralRepositoryFragment(Class<T> interfaceOrImplementation) {
            this.interfaceClass = interfaceOrImplementation;
            this.implementationClass = interfaceOrImplementation;
            this.methods = interfaceOrImplementation.getMethods();
        }

        public StructuralRepositoryFragment(Class<T> interfaceClass, Class<?> implementationClass) {
            this.interfaceClass = interfaceClass;
            this.implementationClass = implementationClass;
            this.methods = interfaceClass.getMethods();
        }

        @Override
        public Class<?> getSignatureContributor() {
            return this.interfaceClass;
        }

        @Override
        public Optional<Class<?>> getImplementationClass() {
            return Optional.of(this.implementationClass);
        }

        @Override
        public Stream<Method> methods() {
            return Arrays.stream(this.methods);
        }

        @Override
        public List<Method> findMethods(String name) {
            return RepositoryFragment.findMethods(name, this.methods);
        }

        @Override
        public boolean hasMethod(Method method) {
            if (RepositoryFragment.hasMethod(method, this.methods)) {
                return true;
            }
            return RepositoryFragment.super.hasMethod(method);
        }

        @Override
        public RepositoryFragment<T> withImplementation(T implementation) {
            return new ImplementedRepositoryFragment<T>(this.interfaceClass, implementation);
        }

        public String toString() {
            return String.format("StructuralRepositoryFragment %s", ClassUtils.getShortName(this.interfaceClass));
        }

        public boolean equals(Object o) {
            if (!(o instanceof StructuralRepositoryFragment)) {
                return false;
            }
            StructuralRepositoryFragment that = (StructuralRepositoryFragment)o;
            if (!ObjectUtils.nullSafeEquals(this.interfaceClass, that.interfaceClass)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.implementationClass, that.implementationClass);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHash((Object[])new Object[]{this.interfaceClass, this.implementationClass});
        }
    }
}

