/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.MapDataBinder;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;
import org.springframework.web.multipart.support.MultipartResolutionDelegate;

public class ProxyingHandlerMethodArgumentResolver
extends ModelAttributeMethodProcessor
implements BeanFactoryAware,
BeanClassLoaderAware {
    private static LogAccessor LOGGER = new LogAccessor(ProxyingHandlerMethodArgumentResolver.class);
    private static final List<String> IGNORED_PACKAGES = List.of("java", "org.springframework");
    private final SpelAwareProxyProjectionFactory proxyFactory;
    private final ObjectFactory<ConversionService> conversionService;
    private final ProjectedPayloadDeprecationLogger deprecationLogger = new ProjectedPayloadDeprecationLogger();

    public ProxyingHandlerMethodArgumentResolver(ObjectFactory<ConversionService> conversionService, boolean annotationNotRequired) {
        super(annotationNotRequired);
        this.proxyFactory = new SpelAwareProxyProjectionFactory();
        this.conversionService = conversionService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.proxyFactory.setBeanFactory(beanFactory);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.proxyFactory.setBeanClassLoader(classLoader);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (!super.supportsParameter(parameter)) {
            return false;
        }
        Class type = parameter.getParameterType();
        if (!type.isInterface()) {
            return false;
        }
        if (MultipartResolutionDelegate.isMultipartArgument((MethodParameter)parameter)) {
            return false;
        }
        if (parameter.hasParameterAnnotation(ProjectedPayload.class) || AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, ProjectedPayload.class) != null) {
            return true;
        }
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            this.deprecationLogger.logDeprecationForParameter(parameter);
            return true;
        }
        if (Arrays.stream(parameter.getParameterAnnotations()).map(Annotation::annotationType).map(Class::getPackageName).anyMatch(it -> it.startsWith("org.springframework"))) {
            return false;
        }
        String packageName = ClassUtils.getPackageName((Class)type);
        if (IGNORED_PACKAGES.stream().noneMatch(packageName::startsWith)) {
            this.deprecationLogger.logDeprecationForParameter(parameter);
            return true;
        }
        return false;
    }

    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        MapDataBinder binder = new MapDataBinder(parameter.getParameterType(), (ConversionService)this.conversionService.getObject());
        binder.bind((PropertyValues)new MutablePropertyValues(request.getParameterMap()));
        return this.proxyFactory.createProjection(parameter.getParameterType(), binder.getTarget());
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
    }

    static class ProjectedPayloadDeprecationLogger {
        private static final String MESSAGE = "Parameter %sat index %s in [%s] is not annotated with @ProjectedPayload. Support for parameters not annotated with @ProjectedPayload (at the parameter or type level) will be dropped in a future version.";
        private final Set<MethodParameter> loggedParameters = Collections.synchronizedSet(new HashSet());

        ProjectedPayloadDeprecationLogger() {
        }

        void logDeprecationForParameter(MethodParameter parameter) {
            if (!this.loggedParameters.add(parameter)) {
                return;
            }
            String paramName = parameter.getParameterName();
            Object paramNameOrEmpty = paramName != null ? "'" + paramName + "' " : "";
            String methodName = parameter.getMethod() != null ? parameter.getMethod().toGenericString() : "constructor";
            LOGGER.warn(() -> ProjectedPayloadDeprecationLogger.lambda$logDeprecationForParameter$0((String)paramNameOrEmpty, parameter, methodName));
        }

        private static /* synthetic */ CharSequence lambda$logDeprecationForParameter$0(String paramNameOrEmpty, MethodParameter parameter, String methodName) {
            return MESSAGE.formatted(paramNameOrEmpty, parameter.getParameterIndex(), methodName);
        }
    }
}

