/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EntityQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;

class TemplatedQuery {
    private static final String EXPRESSION_PARAMETER = "$1#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "$1__HASH__{";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile("([:?])#\\{");
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile("([:?])__HASH__\\{");
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_NAME_VARIABLE = "#entityName";
    private static final String ENTITY_NAME_VARIABLE_EXPRESSION = "#{#entityName";
    private static final Environment DEFAULT_ENVIRONMENT = new StandardEnvironment();

    TemplatedQuery() {
    }

    public static EntityQuery create(String queryString, JpaQueryMethod queryMethod, JpaQueryConfiguration queryContext) {
        return TemplatedQuery.create(queryMethod.getDeclaredQuery(queryString), queryMethod.getEntityInformation(), queryContext);
    }

    public static EntityQuery create(DeclaredQuery declaredQuery, JpaEntityMetadata<?> entityMetadata, JpaQueryConfiguration queryContext) {
        ValueExpressionParser expressionParser = queryContext.getValueExpressionDelegate().getValueExpressionParser();
        String resolvedExpressionQuery = TemplatedQuery.renderQueryIfExpressionOrReturnQuery(declaredQuery.getQueryString(), entityMetadata, expressionParser);
        return EntityQuery.create(declaredQuery.rewrite(resolvedExpressionQuery), queryContext.getSelector());
    }

    static String renderQueryIfExpressionOrReturnQuery(String query, JpaEntityMetadata<?> metadata, ValueExpressionParser parser) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(metadata, (String)"metadata must not be null");
        Assert.notNull((Object)parser, (String)"parser must not be null");
        if (!TemplatedQuery.containsExpression(query)) {
            return query;
        }
        SimpleEvaluationContext evalContext = SimpleEvaluationContext.forReadOnlyDataBinding().build();
        evalContext.setVariable(ENTITY_NAME, (Object)metadata.getEntityName());
        query = TemplatedQuery.potentiallyQuoteExpressionsParameter(query);
        ValueExpression expr = parser.parse(query);
        String result = Objects.toString(expr.evaluate(ValueEvaluationContext.of((Environment)DEFAULT_ENVIRONMENT, (EvaluationContext)evalContext)));
        if (result == null) {
            return query;
        }
        return TemplatedQuery.potentiallyUnquoteParameterExpressions(result);
    }

    private static String potentiallyUnquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    private static String potentiallyQuoteExpressionsParameter(String query) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(query).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }

    private static boolean containsExpression(String query) {
        return query.contains(ENTITY_NAME_VARIABLE_EXPRESSION);
    }
}

