/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.ldap.repository.query.LdapParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapParametersParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapQueryExecution;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.util.Assert;

public abstract class AbstractLdapRepositoryQuery
implements RepositoryQuery {
    private final LdapQueryMethod queryMethod;
    private final Class<?> entityType;
    private final LdapOperations ldapOperations;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;
    private final EntityInstantiators instantiators;

    public AbstractLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators) {
        Assert.notNull((Object)((Object)queryMethod), (String)"LdapQueryMethod must not be null");
        Assert.notNull(entityType, (String)"Entity type must not be null");
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null");
        this.queryMethod = queryMethod;
        this.entityType = entityType;
        this.ldapOperations = ldapOperations;
        this.mappingContext = mappingContext;
        this.instantiators = instantiators;
    }

    public final @Nullable Object execute(Object[] parameters) {
        LdapParametersParameterAccessor parameterAccessor = new LdapParametersParameterAccessor(this.queryMethod, parameters);
        LdapQuery query = this.createQuery(parameterAccessor);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        Class typeToRead = processor.getReturnedType().getDomainType();
        LdapQueryExecution.ResultProcessingConverter converter = new LdapQueryExecution.ResultProcessingConverter(processor, this.mappingContext, this.instantiators);
        LdapQueryExecution.ResultProcessingExecution execution = new LdapQueryExecution.ResultProcessingExecution(this.getLdapQueryExecutionToWrap(typeToRead, converter), converter);
        return execution.execute(query);
    }

    private LdapQueryExecution getLdapQueryExecutionToWrap(Class<?> typeToRead, Converter<Object, Object> resultProcessing) {
        if (this.queryMethod.isCollectionQuery()) {
            return new LdapQueryExecution.CollectionExecution(this.ldapOperations, typeToRead);
        }
        if (this.queryMethod.isStreamQuery()) {
            return new LdapQueryExecution.StreamExecution(this.ldapOperations, typeToRead, resultProcessing);
        }
        return new LdapQueryExecution.FindOneExecution(this.ldapOperations, typeToRead);
    }

    protected abstract LdapQuery createQuery(LdapParameterAccessor var1);

    protected Class<?> getEntityClass() {
        return this.entityType;
    }

    public final QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

