/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Limit;
import org.springframework.data.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapQueryCreator;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;

public class PartTreeLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final PartTree partTree;
    private final ObjectDirectoryMapper objectDirectoryMapper;

    public PartTreeLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators) {
        super(queryMethod, entityType, ldapOperations, mappingContext, instantiators);
        this.partTree = new PartTree(queryMethod.getName(), entityType);
        this.objectDirectoryMapper = ldapOperations.getObjectDirectoryMapper();
    }

    @Override
    protected LdapQuery createQuery(LdapParameterAccessor parameters) {
        List inputProperties = Collections.emptyList();
        ReturnedType returnedType = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)parameters).getReturnedType();
        if (returnedType.needsCustomConstruction()) {
            inputProperties = returnedType.getInputProperties();
        }
        LdapQueryCreator queryCreator = new LdapQueryCreator(this.partTree, this.getEntityClass(), this.objectDirectoryMapper, parameters, inputProperties);
        LdapQuery query = (LdapQuery)queryCreator.createQuery();
        if (this.getQueryMethod().getParameters().hasLimitParameter() || this.partTree.isLimiting()) {
            LdapQueryBuilder builder = LdapQueryBuilder.fromQuery((LdapQuery)query);
            Limit limit = parameters.getLimit();
            if (this.partTree.isLimiting()) {
                builder.countLimit(this.partTree.getResultLimit().max());
            }
            if (this.getQueryMethod().getParameters().hasLimitParameter()) {
                builder.countLimit(limit.isLimited() ? limit.max() : 0);
            }
            return builder;
        }
        return query;
    }
}

