/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.IndexOptions;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

abstract class IndexConverters {
    private static final Converter<IndexDefinition, IndexOptions> DEFINITION_TO_MONGO_INDEX_OPTIONS = IndexConverters.getIndexDefinitionIndexOptionsConverter();
    private static final Converter<Document, IndexInfo> DOCUMENT_INDEX_INFO = IndexConverters.getDocumentIndexInfoConverter();

    private IndexConverters() {
    }

    static Converter<IndexDefinition, IndexOptions> indexDefinitionToIndexOptionsConverter() {
        return DEFINITION_TO_MONGO_INDEX_OPTIONS;
    }

    static Converter<Document, IndexInfo> documentToIndexInfoConverter() {
        return DOCUMENT_INDEX_INFO;
    }

    private static Converter<IndexDefinition, IndexOptions> getIndexDefinitionIndexOptionsConverter() {
        return indexDefinition -> {
            Document indexOptions = indexDefinition.getIndexOptions();
            IndexOptions ops = new IndexOptions();
            if (indexOptions.containsKey((Object)"name")) {
                ops = ops.name(indexOptions.get((Object)"name").toString());
            }
            if (indexOptions.containsKey((Object)"unique")) {
                ops = ops.unique(((Boolean)indexOptions.get((Object)"unique")).booleanValue());
            }
            if (indexOptions.containsKey((Object)"sparse")) {
                ops = ops.sparse(((Boolean)indexOptions.get((Object)"sparse")).booleanValue());
            }
            if (indexOptions.containsKey((Object)"background")) {
                ops = ops.background(((Boolean)indexOptions.get((Object)"background")).booleanValue());
            }
            if (indexOptions.containsKey((Object)"expireAfterSeconds")) {
                ops = ops.expireAfter((Long)indexOptions.get((Object)"expireAfterSeconds"), TimeUnit.SECONDS);
            }
            if (indexOptions.containsKey((Object)"min")) {
                ops = ops.min(Double.valueOf(((Number)indexOptions.get((Object)"min")).doubleValue()));
            }
            if (indexOptions.containsKey((Object)"max")) {
                ops = ops.max(Double.valueOf(((Number)indexOptions.get((Object)"max")).doubleValue()));
            }
            if (indexOptions.containsKey((Object)"bits")) {
                ops = ops.bits((Integer)indexOptions.get((Object)"bits"));
            }
            if (indexOptions.containsKey((Object)"bucketSize")) {
                ops = ops.bucketSize(Double.valueOf(((Number)indexOptions.get((Object)"bucketSize")).doubleValue()));
            }
            if (indexOptions.containsKey((Object)"default_language")) {
                ops = ops.defaultLanguage(indexOptions.get((Object)"default_language").toString());
            }
            if (indexOptions.containsKey((Object)"language_override")) {
                ops = ops.languageOverride(indexOptions.get((Object)"language_override").toString());
            }
            if (indexOptions.containsKey((Object)"weights")) {
                ops = ops.weights((Bson)((Document)indexOptions.get((Object)"weights")));
            }
            for (String key : indexOptions.keySet()) {
                if (!ObjectUtils.nullSafeEquals((Object)"2dsphere", (Object)indexOptions.get((Object)key))) continue;
                ops = ops.sphereVersion(Integer.valueOf(2));
            }
            if (indexOptions.containsKey((Object)"partialFilterExpression")) {
                ops = ops.partialFilterExpression((Bson)((Document)indexOptions.get((Object)"partialFilterExpression")));
            }
            if (indexOptions.containsKey((Object)"collation")) {
                ops = ops.collation(IndexConverters.fromDocument((Document)indexOptions.get((Object)"collation", Document.class)));
            }
            if (indexOptions.containsKey((Object)"wildcardProjection")) {
                ops.wildcardProjection((Bson)indexOptions.get((Object)"wildcardProjection", Document.class));
            }
            if (indexOptions.containsKey((Object)"hidden")) {
                ops = ops.hidden(((Boolean)indexOptions.get((Object)"hidden")).booleanValue());
            }
            return ops;
        };
    }

    @Nullable
    public static com.mongodb.client.model.Collation fromDocument(@Nullable Document source) {
        if (source == null) {
            return null;
        }
        return Collation.from(source).toMongoCollation();
    }

    private static Converter<Document, IndexInfo> getDocumentIndexInfoConverter() {
        return IndexInfo::indexInfoOf;
    }
}

