/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert.encryption;

import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.encryption.EncryptionContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.expression.EvaluationContext;

class ExplicitEncryptionContext
implements EncryptionContext {
    private final MongoConversionContext conversionContext;

    public ExplicitEncryptionContext(MongoConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    @Override
    public MongoPersistentProperty getProperty() {
        return this.conversionContext.getProperty();
    }

    @Override
    public @Nullable Object lookupValue(String path) {
        return this.conversionContext.getValue(path);
    }

    @Override
    public @Nullable Object convertToMongoType(Object value) {
        return this.conversionContext.write(value);
    }

    @Override
    public EvaluationContext getEvaluationContext(@Nullable Object source) {
        if (this.conversionContext.getSpELContext() != null) {
            return this.conversionContext.getSpELContext().getEvaluationContext(source);
        }
        throw new IllegalStateException("SpEL context not present");
    }

    @Override
    public <T> @Nullable T read(@Nullable Object value, TypeInformation<T> target) {
        return this.conversionContext.read(value, target);
    }

    @Override
    public <T> @Nullable T write(@Nullable Object value, TypeInformation<T> target) {
        return this.conversionContext.write(value, target);
    }

    @Override
    public @Nullable MongoConversionContext.OperatorContext getOperatorContext() {
        return this.conversionContext.getOperatorContext();
    }
}

