/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ClassIntrospector;

class MappedJacksonProperties {
    private final Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName;
    private final Map<String, PersistentProperty<?>> fieldNameToProperty;
    private final Set<BeanPropertyDefinition> unmappedProperties;
    private final Set<String> ignoredPropertyNames;
    private final boolean anySetterFound;

    private MappedJacksonProperties(Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName, Map<String, PersistentProperty<?>> fieldNameToProperty, Set<BeanPropertyDefinition> unmappedProperties, Set<String> ignoredPropertyNames, boolean anySetterFound) {
        this.propertyToFieldName = propertyToFieldName;
        this.fieldNameToProperty = fieldNameToProperty;
        this.unmappedProperties = unmappedProperties;
        this.ignoredPropertyNames = ignoredPropertyNames;
        this.anySetterFound = anySetterFound;
    }

    private MappedJacksonProperties(PersistentEntity<?, ? extends PersistentProperty<?>> entity, BeanDescription description) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)description, (String)"BeanDescription must not be null");
        this.propertyToFieldName = new HashMap();
        this.fieldNameToProperty = new HashMap();
        this.unmappedProperties = new HashSet<BeanPropertyDefinition>();
        this.anySetterFound = description.findAnySetterAccessor() != null;
        this.ignoredPropertyNames = new HashSet<String>(description.getIgnoredPropertyNames());
        JsonIgnoreProperties annotation = (JsonIgnoreProperties)entity.findAnnotation(JsonIgnoreProperties.class);
        if (annotation != null) {
            Collections.addAll(this.ignoredPropertyNames, annotation.value());
        }
        for (BeanPropertyDefinition property : description.findProperties()) {
            if (this.ignoredPropertyNames.contains(property.getName())) continue;
            Optional<PersistentProperty> persistentProperty = Optional.ofNullable(entity.getPersistentProperty(property.getInternalName()));
            persistentProperty.ifPresent(it -> {
                this.propertyToFieldName.put((PersistentProperty<?>)it, property);
                this.fieldNameToProperty.put(property.getName(), (PersistentProperty<?>)it);
            });
            if (persistentProperty.isPresent()) continue;
            this.unmappedProperties.add(property);
        }
    }

    public static MappedJacksonProperties forDeserialization(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        DeserializationConfig config = mapper.deserializationConfig();
        ClassIntrospector introspector = config.classIntrospectorInstance();
        JavaType javaType = mapper.constructType((Type)entity.getType());
        BeanDescription description = introspector.forOperation((MapperConfig)config).introspectForDeserialization(javaType, introspector.introspectClassAnnotations(javaType));
        return new MappedJacksonProperties(entity, description);
    }

    public static MappedJacksonProperties forSerialization(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        SerializationConfig config = mapper.serializationConfig();
        ClassIntrospector introspector = config.classIntrospectorInstance();
        JavaType type = mapper.constructType((Type)entity.getType());
        BeanDescription description = introspector.forOperation((MapperConfig)config).introspectForSerialization(type, introspector.introspectClassAnnotations(type));
        return new MappedJacksonProperties(entity, description);
    }

    public static MappedJacksonProperties forDescription(PersistentEntity<?, ?> entity, BeanDescription description) {
        return new MappedJacksonProperties(entity, description);
    }

    public static MappedJacksonProperties none() {
        return new MappedJacksonProperties(Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), false);
    }

    public String getMappedName(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        BeanPropertyDefinition definition = this.propertyToFieldName.get(property);
        if (definition == null) {
            throw new IllegalStateException(String.format("Property '%s' not found", property));
        }
        return definition.getName();
    }

    public boolean hasPersistentPropertyForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty");
        return this.fieldNameToProperty.containsKey(fieldName);
    }

    public @Nullable PersistentProperty<?> getPersistentProperty(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty");
        return this.fieldNameToProperty.get(fieldName);
    }

    public Iterable<String> getSpringDataUnmappedProperties() {
        if (this.unmappedProperties.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> result = new ArrayList<String>(this.unmappedProperties.size());
        for (BeanPropertyDefinition definitions : this.unmappedProperties) {
            result.add(definitions.getInternalName());
        }
        return result;
    }

    public Iterable<String> getIgnoredProperties() {
        return this.ignoredPropertyNames;
    }

    public boolean isMappedProperty(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        return this.propertyToFieldName.containsKey(property);
    }

    public boolean isWritableField(String name) {
        Assert.hasText((String)name, (String)"Property name must not be null or empty");
        if (this.ignoredPropertyNames.contains(name)) {
            return false;
        }
        PersistentProperty<?> property = this.fieldNameToProperty.get(name);
        return property != null ? property.isWritable() : this.anySetterFound;
    }

    public boolean isReadableField(String name) {
        Assert.hasText((String)name, (String)"Property name must not be null or empty");
        if (this.ignoredPropertyNames.contains(name)) {
            return false;
        }
        return this.fieldNameToProperty.get(name) != null;
    }

    public boolean isExposedProperty(String name) {
        Assert.hasText((String)name, (String)"Property name must not be null or empty");
        if (this.ignoredPropertyNames.contains(name)) {
            return false;
        }
        PersistentProperty<?> property = this.fieldNameToProperty.get(name);
        return property != null ? property.isWritable() : this.anySetterFound;
    }
}

