/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

public final class QueryParameter {
    private final String name;
    private final @Nullable String value;
    private final boolean required;

    private QueryParameter(String name, @Nullable String value, boolean required) {
        this.name = name;
        this.value = value;
        this.required = required;
    }

    public static QueryParameter of(MethodParameter parameter) {
        String name;
        MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)parameter.getParameter()).get(RequestParam.class);
        String string = name = annotation.isPresent() && annotation.hasNonDefaultValue("name") ? annotation.getString("name") : parameter.getParameterName();
        if (name == null || !StringUtils.hasText((String)name)) {
            throw new IllegalStateException(String.format("Couldn't determine parameter name for %s!", parameter));
        }
        boolean required = annotation.isPresent() && annotation.hasNonDefaultValue("required") ? annotation.getBoolean("required") : !Optional.class.equals((Object)parameter.getParameterType());
        return required ? QueryParameter.required(name) : QueryParameter.optional(name);
    }

    public static QueryParameter required(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new QueryParameter(name, null, true);
    }

    public static QueryParameter optional(String name) {
        return new QueryParameter(name, null, false);
    }

    public QueryParameter withValue(@Nullable String value) {
        return this.value == value ? this : new QueryParameter(this.name, value, this.required);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getValue() {
        return this.value;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        return this.required == that.required && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.required);
    }

    public String toString() {
        return "QueryParameter(name=" + this.name + ", value=" + this.value + ", required=" + this.required + ")";
    }
}

