/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
final class CollectionJsonError {
    private final String title;
    private final String code;
    private final String message;

    @JsonCreator
    CollectionJsonError(@JsonProperty(value="title") @Nullable String title, @JsonProperty(value="code") @Nullable String code, @JsonProperty(value="message") @Nullable String message) {
        this.title = title;
        this.code = code;
        this.message = message;
    }

    CollectionJsonError() {
        this(null, null, null);
    }

    CollectionJsonError withTitle(String title) {
        return this.title == title ? this : new CollectionJsonError(title, this.code, this.message);
    }

    CollectionJsonError withCode(String code) {
        return this.code == code ? this : new CollectionJsonError(this.title, code, this.message);
    }

    CollectionJsonError withMessage(String message) {
        return this.message == message ? this : new CollectionJsonError(this.title, this.code, message);
    }

    public String getTitle() {
        return this.title;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonError that = (CollectionJsonError)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.code, that.code) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.code, this.message);
    }

    public String toString() {
        return "CollectionJsonError(title=" + this.title + ", code=" + this.code + ", message=" + this.message + ")";
    }
}

