/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class OSDelegatingFileTailingMessageProducer
extends FileTailingMessageProducerSupport
implements SchedulingAwareRunnable {
    private boolean enableStatusReader = true;
    private String options = "-F -n 0";
    private volatile String command = "ADAPTER_NOT_INITIALIZED";
    private volatile String[] tailCommand;
    private volatile Process nativeTailProcess;
    private volatile BufferedReader stdOutReader;

    public void setOptions(String options) {
        this.options = options == null ? "" : options;
    }

    public void setEnableStatusReader(boolean enableStatusReader) {
        this.enableStatusReader = enableStatusReader;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType() + " (native)";
    }

    public boolean isLongLived() {
        return true;
    }

    protected void onInit() {
        super.onInit();
        Assert.notNull((Object)this.getFile(), (String)"File cannot be null");
    }

    @Override
    protected void doStart() {
        super.doStart();
        this.destroyProcess();
        String[] tailOptions = this.options.split("\\s+");
        this.tailCommand = new String[tailOptions.length + 2];
        this.tailCommand[0] = "tail";
        this.tailCommand[this.tailCommand.length - 1] = this.getFile().getAbsolutePath();
        System.arraycopy(tailOptions, 0, this.tailCommand, 1, tailOptions.length);
        this.command = String.join((CharSequence)" ", this.tailCommand);
        this.getTaskExecutor().execute(this::runExec);
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.destroyProcess();
    }

    private void destroyProcess() {
        Process process = this.nativeTailProcess;
        if (process != null) {
            process.destroy();
            this.nativeTailProcess = null;
        }
    }

    private void runExec() {
        this.destroyProcess();
        this.logger.info((CharSequence)"Starting tail process");
        try {
            Process process = Runtime.getRuntime().exec(this.tailCommand);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.nativeTailProcess = process;
            this.startProcessMonitor();
            if (this.enableStatusReader) {
                this.startStatusReader();
            }
            this.stdOutReader = reader;
            this.getTaskExecutor().execute((Runnable)((Object)this));
        }
        catch (IOException e) {
            throw new MessagingException("Failed to exec tail command: '" + this.command + "'", (Throwable)e);
        }
    }

    private void startProcessMonitor() {
        this.getTaskExecutor().execute(() -> {
            Process process = this.nativeTailProcess;
            if (process == null) {
                this.logger.debug((CharSequence)"Process destroyed before starting process monitor");
                return;
            }
            try {
                this.logger.debug(() -> "Monitoring process " + process);
                int result = process.waitFor();
                this.logger.info(() -> "tail process terminated with value " + result);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.error((Throwable)ex, (CharSequence)"Interrupted - stopping adapter");
                this.stop();
            }
            finally {
                this.destroyProcess();
            }
            if (this.isRunning()) {
                long missingFileDelay = this.getMissingFileDelay();
                this.logger.info(() -> "Restarting tail process in " + missingFileDelay + " milliseconds");
                this.getTaskScheduler().schedule(this::runExec, Instant.now().plusMillis(missingFileDelay));
            }
        });
    }

    private void startStatusReader() {
        Process process = this.nativeTailProcess;
        if (process == null) {
            this.logger.debug((CharSequence)"Process destroyed before starting stderr reader");
            return;
        }
        this.getTaskExecutor().execute(() -> {
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            this.logger.debug((CharSequence)"Reading stderr");
            try {
                String statusMessage;
                while ((statusMessage = errorReader.readLine()) != null) {
                    this.publish(statusMessage);
                    this.logger.trace((CharSequence)statusMessage);
                }
            }
            catch (IOException e1) {
                this.logger.debug((Throwable)e1, (CharSequence)"Exception on tail error reader");
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e2) {
                    this.logger.debug((Throwable)e2, (CharSequence)"Exception while closing stderr");
                }
            }
        });
    }

    public void run() {
        try {
            String line;
            this.logger.debug((CharSequence)"Reading stdout");
            while ((line = this.stdOutReader.readLine()) != null) {
                this.send(line);
            }
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, (CharSequence)"Exception on tail reader");
            try {
                this.stdOutReader.close();
            }
            catch (IOException e1) {
                this.logger.debug((Throwable)e1, (CharSequence)"Exception while closing stdout");
            }
            this.destroyProcess();
        }
    }
}

