/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.core;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.jpa.core.JpaOperations;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.Assert;

abstract class AbstractJpaOperations
implements JpaOperations,
InitializingBean {
    protected EntityManager entityManager;
    private EntityManagerFactory entityManagerFactory;

    AbstractJpaOperations() {
    }

    public void setEntityManager(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"The provided entitymanager must not be null.");
        this.entityManager = entityManager;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"The provided entitymanagerFactory must not be null.");
        this.entityManagerFactory = entityManagerFactory;
    }

    public final void afterPropertiesSet() {
        this.onInit();
    }

    protected void onInit() {
        if (this.entityManager == null && this.entityManagerFactory != null) {
            this.entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.entityManagerFactory);
        }
        Assert.notNull((Object)this.entityManager, (String)"The entitymanager is null. Please set either the entityManager or the entityManagerFactory.");
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }
}

