/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.inbound;

import org.jspecify.annotations.Nullable;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class JpaPollingChannelAdapter
extends AbstractMessageSource<Object> {
    private final JpaExecutor jpaExecutor;

    public JpaPollingChannelAdapter(JpaExecutor jpaExecutor) {
        Assert.notNull((Object)jpaExecutor, (String)"jpaExecutor must not be null.");
        this.jpaExecutor = jpaExecutor;
    }

    protected void onInit() {
        this.jpaExecutor.setBeanFactory(this.getBeanFactory());
    }

    protected @Nullable Object doReceive() {
        Object result = this.jpaExecutor.poll();
        return ObjectUtils.isEmpty((Object)result) ? null : result;
    }

    public String getComponentType() {
        return "jpa:inbound-channel-adapter";
    }
}

