/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.outbound;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.ws.outbound.AbstractWebServiceOutboundGateway;
import org.springframework.integration.ws.outbound.MarshallingWebServiceOutboundGateway;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    private final SourceExtractor<?> sourceExtractor;
    private boolean extractPayload = true;

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider) {
        this(destinationProvider, null, null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, SourceExtractor<?> sourceExtractor) {
        this(destinationProvider, sourceExtractor, null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, @Nullable SourceExtractor<?> sourceExtractor, @Nullable WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new DefaultSourceExtractor();
    }

    public SimpleWebServiceOutboundGateway(String uri) {
        this(uri, null, null);
    }

    public SimpleWebServiceOutboundGateway(String uri, SourceExtractor<?> sourceExtractor) {
        this(uri, sourceExtractor, null);
    }

    public SimpleWebServiceOutboundGateway(@Nullable String uri, @Nullable SourceExtractor<?> sourceExtractor, @Nullable WebServiceMessageFactory messageFactory) {
        super(uri, messageFactory);
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new DefaultSourceExtractor();
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "ws:outbound-gateway(simple)";
    }

    @Override
    protected @Nullable Object doHandle(String uri, Message<?> requestMessage, @Nullable WebServiceMessageCallback requestCallback) {
        Object requestPayload = requestMessage.getPayload();
        Object responseResultInstance = null;
        if (requestPayload instanceof String) {
            responseResultInstance = new StringResult();
        } else if (requestPayload instanceof Document) {
            responseResultInstance = new DOMResult();
        }
        return this.getWebServiceTemplate().sendAndReceive(uri, (WebServiceMessageCallback)new SimpleRequestMessageCallback(requestCallback, requestMessage), (WebServiceMessageExtractor)new SimpleResponseMessageExtractor((Result)responseResultInstance));
    }

    private static class DefaultSourceExtractor
    extends TransformerObjectSupport
    implements SourceExtractor<DOMSource> {
        DefaultSourceExtractor() {
        }

        public @Nullable DOMSource extractData(@Nullable Source source) throws TransformerException {
            if (source instanceof DOMSource) {
                DOMSource domSource = (DOMSource)source;
                return domSource;
            }
            if (source == null) {
                return new DOMSource();
            }
            DOMResult result = new DOMResult();
            this.transform(source, result);
            return new DOMSource(result.getNode());
        }
    }

    private final class SimpleRequestMessageCallback
    extends AbstractWebServiceOutboundGateway.RequestMessageCallback {
        SimpleRequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            super(requestCallback, requestMessage);
        }

        @Override
        public void doWithMessageInternal(WebServiceMessage message, Object payload) throws IOException, TransformerException {
            Source source = this.extractSource(payload);
            if (source == null) {
                source = new DOMSource();
            }
            this.transform(source, message.getPayloadResult());
            if (message instanceof MimeMessage && payload instanceof MimeMessage) {
                SimpleRequestMessageCallback.copyAttachments((MimeMessage)payload, (MimeMessage)message);
            }
        }

        private @Nullable Source extractSource(Object requestPayload) throws IOException, TransformerException {
            Source source;
            if (requestPayload instanceof Source) {
                Source sourcePayload;
                source = sourcePayload = (Source)requestPayload;
                Object o = SimpleWebServiceOutboundGateway.this.sourceExtractor.extractData(source);
                Assert.isInstanceOf(Source.class, (Object)o);
                source = (Source)o;
            } else if (requestPayload instanceof String) {
                String string = (String)requestPayload;
                source = new StringSource(string);
            } else if (requestPayload instanceof Document) {
                Document document = (Document)requestPayload;
                source = new DOMSource(document);
            } else if (requestPayload instanceof WebServiceMessage) {
                WebServiceMessage webServiceMessage = (WebServiceMessage)requestPayload;
                source = webServiceMessage.getPayloadSource();
            } else {
                throw new MessagingException("Unsupported payload type '" + String.valueOf(requestPayload.getClass()) + "'. " + ((Object)((Object)this)).getClass().getName() + " only supports 'java.lang.String', '" + Source.class.getName() + "', '" + Document.class.getName() + "' and '" + WebServiceMessage.class.getName() + "'. Consider either using the '" + MarshallingWebServiceOutboundGateway.class.getName() + "' or a Message Transformer.");
            }
            return source;
        }

        private static void copyAttachments(MimeMessage source, MimeMessage target) {
            Iterator attachments = source.getAttachments();
            while (attachments.hasNext()) {
                Attachment attachment = (Attachment)attachments.next();
                target.addAttachment(attachment.getContentId(), attachment.getDataHandler());
            }
        }
    }

    private final class SimpleResponseMessageExtractor
    extends AbstractWebServiceOutboundGateway.ResponseMessageExtractor {
        private final @Nullable Result result;

        SimpleResponseMessageExtractor(Result result) {
            this.result = result;
        }

        @Override
        public @Nullable Object doExtractData(WebServiceMessage message) throws TransformerException {
            if (!SimpleWebServiceOutboundGateway.this.extractPayload) {
                return message;
            }
            Source payloadSource = message.getPayloadSource();
            if (payloadSource != null && this.result != null) {
                this.transform(payloadSource, this.result);
                if (this.result instanceof StringResult) {
                    return this.result.toString();
                }
                Result result = this.result;
                if (result instanceof DOMResult) {
                    DOMResult domResult = (DOMResult)result;
                    return domResult.getNode();
                }
                return this.result;
            }
            return payloadSource;
        }
    }
}

