/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import org.springframework.modulith.aptk.tools.AnnotationUtils;
import org.springframework.modulith.aptk.tools.TypeMirrorWrapper;
import org.springframework.modulith.aptk.tools.wrapper.AnnotationValueWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ExecutableElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeElementWrapper;

public class AnnotationMirrorWrapper {
    private final AnnotationMirror annotationMirror;

    private AnnotationMirrorWrapper(AnnotationMirror annotationMirror) {
        if (annotationMirror == null) {
            throw new IllegalArgumentException("Passed annotationMirror must not be null");
        }
        this.annotationMirror = annotationMirror;
    }

    public AnnotationMirror unwrap() {
        return this.annotationMirror;
    }

    public DeclaredType getAnnotationType() {
        return this.annotationMirror.getAnnotationType();
    }

    public TypeMirrorWrapper getAnnotationTypeAsWrappedTypeMirror() {
        return TypeMirrorWrapper.wrap(this.getAnnotationType());
    }

    public TypeElementWrapper getAnnotationTypeAsWrappedTypeElement() {
        return this.getAnnotationTypeAsWrappedTypeMirror().getTypeElement().get();
    }

    public Optional<TypeMirrorWrapper> getAttributeTypeMirror() {
        return this.getAttributeTypeMirror("value");
    }

    public Optional<TypeMirrorWrapper> getAttributeTypeMirror(String attributeName) {
        Optional<ExecutableElementWrapper> annotationAttribute = this.getAnnotationTypeAsWrappedTypeElement().getMethod(attributeName, new Class[0]);
        return annotationAttribute.map(ExecutableElementWrapper::getReturnType);
    }

    public Optional<AnnotationValueWrapper> getAttribute() {
        return this.getAttribute("value");
    }

    public Optional<AnnotationValueWrapper> getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("passed attribute name must not be null");
        }
        if (!this.hasAttribute(name)) {
            throw new IllegalArgumentException("Passed attribute name is not valid. Annotation " + this.annotationMirror.getAnnotationType().asElement().getSimpleName() + " has the following attributes : " + this.getAttributeNames());
        }
        AnnotationValue annotationValue = AnnotationUtils.getAnnotationValueOfAttribute(this.annotationMirror, name);
        return annotationValue != null ? Optional.of(AnnotationValueWrapper.wrap(annotationValue)) : Optional.empty();
    }

    public AnnotationValueWrapper getAttributeWithDefault() {
        return this.getAttributeWithDefault("value");
    }

    public AnnotationValueWrapper getAttributeWithDefault(String name) {
        if (name == null) {
            throw new IllegalArgumentException("passed attribute name must not be null");
        }
        if (!this.hasAttribute(name)) {
            throw new IllegalArgumentException("Passed attribute name is not valid. Annotation " + this.annotationMirror.getAnnotationType().asElement().getSimpleName() + " has the following attributes : " + this.getAttributeNames());
        }
        AnnotationValue annotationValue = AnnotationUtils.getAnnotationValueOfAttributeWithDefaults(this.annotationMirror, name);
        return AnnotationValueWrapper.wrap(annotationValue);
    }

    public static Optional<AnnotationMirrorWrapper> get(Element element, Class<? extends Annotation> annotation) {
        if (element == null || annotation == null) {
            return Optional.empty();
        }
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(element, annotation);
        return annotationMirror != null ? Optional.of(new AnnotationMirrorWrapper(annotationMirror)) : Optional.empty();
    }

    public static Optional<AnnotationMirrorWrapper> get(Element element, String annotationFqn) {
        if (element == null || annotationFqn == null) {
            return Optional.empty();
        }
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(element, annotationFqn);
        return annotationMirror != null ? Optional.of(new AnnotationMirrorWrapper(annotationMirror)) : Optional.empty();
    }

    public Set<String> getAttributeNames() {
        return this.annotationMirror.getAnnotationType().asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet());
    }

    public List<String> getAttributeNamesInDeclarationOrder() {
        return this.annotationMirror.getAnnotationType().asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> e.getSimpleName().toString()).collect(Collectors.toList());
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNames().contains(name);
    }

    public TypeMirrorWrapper asTypeMirror() {
        return this.getAnnotationTypeAsWrappedTypeMirror();
    }

    public TypeElementWrapper asElement() {
        return this.getAnnotationTypeAsWrappedTypeElement();
    }

    public String getStringRepresentation() {
        String stringBuilder = "@" + this.asElement().getSimpleName() + this.getAttributeNamesInDeclarationOrder().stream().map(e -> {
            Optional<AnnotationValueWrapper> optionalAnnotationValueWrapper = this.getAttribute((String)e);
            return optionalAnnotationValueWrapper.map(annotationValueWrapper -> e + " = " + this.getAnnotationAttributeValueStringRepresentation((AnnotationValueWrapper)annotationValueWrapper)).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.joining(", ", "(", ")"));
        return stringBuilder.replaceAll("\"", "\\\\\"");
    }

    public String getStringRepresentationWithDefaults() {
        String stringBuilder = "@" + this.asElement().getSimpleName() + this.getAttributeNamesInDeclarationOrder().stream().map(e -> e + " = " + this.getAnnotationAttributeValueStringRepresentation(this.getAttributeWithDefault((String)e))).collect(Collectors.joining(", ", "(", ")"));
        return stringBuilder.replaceAll("\"", "\\\\\"");
    }

    String getAnnotationAttributeValueStringRepresentation(AnnotationValueWrapper annotationValueWrapper) {
        if (annotationValueWrapper.isArray()) {
            return annotationValueWrapper.getArrayValue().stream().map(this::getAnnotationAttributeValueStringRepresentation).collect(Collectors.joining(", ", "{", "}"));
        }
        if (annotationValueWrapper.isEnum()) {
            return annotationValueWrapper.getEnumValue().asType().getSimpleName() + "." + annotationValueWrapper.getEnumValue().getSimpleName();
        }
        if (annotationValueWrapper.isClass()) {
            return annotationValueWrapper.getClassValue().getSimpleName() + ".class";
        }
        return annotationValueWrapper.unwrap().toString();
    }

    public static AnnotationMirrorWrapper wrap(AnnotationMirror annotationMirror) {
        return new AnnotationMirrorWrapper(annotationMirror);
    }

    public static AnnotationMirrorWrapper[] wrap(AnnotationMirror[] annotationMirrors) {
        return annotationMirrors != null ? (AnnotationMirrorWrapper[])Arrays.stream(annotationMirrors).map(AnnotationMirrorWrapper::wrap).toArray(AnnotationMirrorWrapper[]::new) : null;
    }
}

