/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.internal.util;

import java.net.URL;
import org.springframework.util.Assert;

public class ChainedClassLoader
extends ClassLoader {
    private final ClassLoader[] loaders;

    public ChainedClassLoader(ClassLoader[] loaders) {
        Assert.notEmpty((Object[])loaders);
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader classLoader = loaders[i];
            Assert.notNull((Object)classLoader, (String)"null classloaders not allowed");
        }
        this.loaders = (ClassLoader[])loaders.clone();
    }

    public URL getResource(String name) {
        URL url = null;
        for (int i = 0; i < this.loaders.length; ++i) {
            ClassLoader loader = this.loaders[i];
            url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (int i = 0; i < this.loaders.length; ++i) {
            ClassLoader loader = this.loaders[i];
            try {
                clazz = loader.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }
}

