/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.event.OAuth2AuthorizedClientRefreshedEvent;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;

public final class RefreshTokenOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider,
ApplicationEventPublisherAware {
    private OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient = new DefaultRefreshTokenTokenResponseClient();
    private ApplicationEventPublisher applicationEventPublisher;
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient == null || authorizedClient.getRefreshToken() == null || !this.hasTokenExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return null;
        }
        Object requestScope = context.getAttribute(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME);
        Set<String> scopes = Collections.emptySet();
        if (requestScope != null) {
            Assert.isInstanceOf(String[].class, requestScope, (String)("The context attribute must be of type String[] '" + OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME + "'"));
            scopes = new HashSet<String>(Arrays.asList((String[])requestScope));
        }
        OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest = new OAuth2RefreshTokenGrantRequest(authorizedClient.getClientRegistration(), authorizedClient.getAccessToken(), authorizedClient.getRefreshToken(), scopes);
        OAuth2AccessTokenResponse tokenResponse = this.getTokenResponse(authorizedClient, refreshTokenGrantRequest);
        OAuth2AuthorizedClient refreshedAuthorizedClient = new OAuth2AuthorizedClient(authorizedClient.getClientRegistration(), context.getPrincipal().getName(), tokenResponse.getAccessToken(), tokenResponse.getRefreshToken());
        if (this.applicationEventPublisher != null) {
            OAuth2AuthorizedClientRefreshedEvent authorizedClientRefreshedEvent = new OAuth2AuthorizedClientRefreshedEvent(tokenResponse, refreshedAuthorizedClient);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)authorizedClientRefreshedEvent);
        }
        return refreshedAuthorizedClient;
    }

    private OAuth2AccessTokenResponse getTokenResponse(OAuth2AuthorizedClient authorizedClient, OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        try {
            return this.accessTokenResponseClient.getTokenResponse(refreshTokenGrantRequest);
        }
        catch (OAuth2AuthorizationException ex) {
            throw new ClientAuthorizationException(ex.getError(), authorizedClient.getClientRegistration().getRegistrationId(), ex);
        }
    }

    private boolean hasTokenExpired(OAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"applicationEventPublisher cannot be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

