/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSession;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisSessionExpirationPolicy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisOperationsSessionRepository
implements SessionRepository<RedisSession> {
    static final String BOUNDED_HASH_KEY_PREFIX = "spring:session:sessions:";
    static final String CREATION_TIME_ATTR = "creationTime";
    static final String MAX_INACTIVE_ATTR = "maxInactiveInterval";
    static final String LAST_ACCESSED_ATTR = "lastAccessedTime";
    static final String SESSION_ATTR_PREFIX = "sessionAttr:";
    private final RedisOperations<String, ExpiringSession> sessionRedisOperations;
    private final RedisSessionExpirationPolicy expirationPolicy;
    private Integer defaultMaxInactiveInterval;

    public RedisOperationsSessionRepository(RedisConnectionFactory redisConnectionFactory) {
        this((RedisOperations<String, ExpiringSession>)RedisOperationsSessionRepository.createDefaultTemplate(redisConnectionFactory));
    }

    public RedisOperationsSessionRepository(RedisOperations<String, ExpiringSession> sessionRedisOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        this.sessionRedisOperations = sessionRedisOperations;
        this.expirationPolicy = new RedisSessionExpirationPolicy(sessionRedisOperations);
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Override
    public void save(RedisSession session) {
        session.saveDelta();
    }

    @Scheduled(cron="0 * * * * *")
    public void cleanupExpiredSessions() {
        this.expirationPolicy.cleanExpiredSessions();
    }

    @Override
    public RedisSession getSession(String id) {
        return this.getSession(id, false);
    }

    private RedisSession getSession(String id, boolean allowExpired) {
        Map entries = this.getSessionBoundHashOperations(id).entries();
        if (entries.isEmpty()) {
            return null;
        }
        MapSession loaded = new MapSession();
        loaded.setId(id);
        for (Map.Entry entry : entries.entrySet()) {
            String key = (String)entry.getKey();
            if (CREATION_TIME_ATTR.equals(key)) {
                loaded.setCreationTime((Long)entry.getValue());
                continue;
            }
            if (MAX_INACTIVE_ATTR.equals(key)) {
                loaded.setMaxInactiveIntervalInSeconds((Integer)entry.getValue());
                continue;
            }
            if (LAST_ACCESSED_ATTR.equals(key)) {
                loaded.setLastAccessedTime((Long)entry.getValue());
                continue;
            }
            if (!key.startsWith(SESSION_ATTR_PREFIX)) continue;
            loaded.setAttribute(key.substring(SESSION_ATTR_PREFIX.length()), entry.getValue());
        }
        if (!allowExpired && loaded.isExpired()) {
            return null;
        }
        RedisSession result = new RedisSession(loaded);
        result.originalLastAccessTime = loaded.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(loaded.getMaxInactiveIntervalInSeconds());
        result.setLastAccessedTime(System.currentTimeMillis());
        return result;
    }

    @Override
    public void delete(String sessionId) {
        RedisSession session = this.getSession(sessionId, true);
        if (session == null) {
            return;
        }
        String key = RedisOperationsSessionRepository.getKey(sessionId);
        this.expirationPolicy.onDelete(session);
        this.sessionRedisOperations.delete((Object)key);
    }

    @Override
    public RedisSession createSession() {
        RedisSession redisSession = new RedisSession();
        if (this.defaultMaxInactiveInterval != null) {
            redisSession.setMaxInactiveIntervalInSeconds(this.defaultMaxInactiveInterval);
        }
        return redisSession;
    }

    static String getKey(String sessionId) {
        return BOUNDED_HASH_KEY_PREFIX + sessionId;
    }

    static String getSessionAttrNameKey(String attributeName) {
        return SESSION_ATTR_PREFIX + attributeName;
    }

    private BoundHashOperations<String, Object, Object> getSessionBoundHashOperations(String sessionId) {
        String key = RedisOperationsSessionRepository.getKey(sessionId);
        return this.sessionRedisOperations.boundHashOps((Object)key);
    }

    private static RedisTemplate createDefaultTemplate(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory(connectionFactory);
        template.afterPropertiesSet();
        return template;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class RedisSession
    implements ExpiringSession {
        private final MapSession cached;
        private Long originalLastAccessTime;
        private Map<String, Object> delta = new HashMap<String, Object>();

        RedisSession() {
            this(new MapSession());
            this.delta.put(RedisOperationsSessionRepository.CREATION_TIME_ATTR, this.getCreationTime());
            this.delta.put(RedisOperationsSessionRepository.MAX_INACTIVE_ATTR, this.getMaxInactiveIntervalInSeconds());
            this.delta.put(RedisOperationsSessionRepository.LAST_ACCESSED_ATTR, this.getLastAccessedTime());
        }

        RedisSession(MapSession cached) {
            Assert.notNull((Object)"MapSession cannot be null");
            this.cached = cached;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.delta.put(RedisOperationsSessionRepository.LAST_ACCESSED_ATTR, this.getLastAccessedTime());
        }

        @Override
        public boolean isExpired() {
            return this.cached.isExpired();
        }

        @Override
        public long getCreationTime() {
            return this.cached.getCreationTime();
        }

        @Override
        public String getId() {
            return this.cached.getId();
        }

        @Override
        public long getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        @Override
        public void setMaxInactiveIntervalInSeconds(int interval) {
            this.cached.setMaxInactiveIntervalInSeconds(interval);
            this.delta.put(RedisOperationsSessionRepository.MAX_INACTIVE_ATTR, this.getMaxInactiveIntervalInSeconds());
        }

        @Override
        public int getMaxInactiveIntervalInSeconds() {
            return this.cached.getMaxInactiveIntervalInSeconds();
        }

        public Object getAttribute(String attributeName) {
            return this.cached.getAttribute(attributeName);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.delta.put(RedisOperationsSessionRepository.getSessionAttrNameKey(attributeName), attributeValue);
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.cached.removeAttribute(attributeName);
            this.delta.put(RedisOperationsSessionRepository.getSessionAttrNameKey(attributeName), null);
        }

        private void saveDelta() {
            String sessionId = this.getId();
            RedisOperationsSessionRepository.this.getSessionBoundHashOperations(sessionId).putAll(this.delta);
            this.delta = new HashMap<String, Object>(this.delta.size());
            RedisOperationsSessionRepository.this.expirationPolicy.onExpirationUpdated(this.originalLastAccessTime, this);
        }
    }
}

