/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.reactive.server.WebTestClient;

public class JsonPathAssertions {
    private final WebTestClient.BodyContentSpec bodySpec;
    private final String content;
    private final JsonPathExpectationsHelper pathHelper;

    JsonPathAssertions(WebTestClient.BodyContentSpec spec, String content, String expression, Object ... args) {
        this.bodySpec = spec;
        this.content = content;
        this.pathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public WebTestClient.BodyContentSpec isEqualTo(Object expectedValue) {
        this.pathHelper.assertValue(this.content, expectedValue);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec exists() {
        this.pathHelper.exists(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec doesNotExist() {
        this.pathHelper.doesNotExist(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isEmpty() {
        this.pathHelper.assertValueIsEmpty(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNotEmpty() {
        this.pathHelper.assertValueIsNotEmpty(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec hasJsonPath() {
        this.pathHelper.hasJsonPath(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec doesNotHaveJsonPath() {
        this.pathHelper.doesNotHaveJsonPath(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isBoolean() {
        this.pathHelper.assertValueIsBoolean(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNumber() {
        this.pathHelper.assertValueIsNumber(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isArray() {
        this.pathHelper.assertValueIsArray(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isMap() {
        this.pathHelper.assertValueIsMap(this.content);
        return this.bodySpec;
    }
}

