/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PathResourceResolver
extends AbstractResourceResolver {
    @Nullable
    private Resource[] allowedLocations;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    @Nullable
    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String path, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (StringUtils.hasText((String)path)) {
            return this.getResource(path, locations).map(resource -> path);
        }
        return Mono.empty();
    }

    private Mono<Resource> getResource(String resourcePath, List<? extends Resource> locations) {
        return Flux.fromIterable(locations).concatMap(location -> this.getResource(resourcePath, (Resource)location)).next();
    }

    protected Mono<Resource> getResource(String resourcePath, Resource location) {
        try {
            Resource resource;
            if (!(location instanceof UrlResource)) {
                resourcePath = UriUtils.decode((String)resourcePath, (Charset)StandardCharsets.UTF_8);
            }
            if ((resource = location.createRelative(resourcePath)).isReadable()) {
                if (this.checkResource(resource, location)) {
                    return Mono.just((Object)resource);
                }
                if (this.logger.isWarnEnabled()) {
                    Resource[] allowed = this.getAllowedLocations();
                    this.logger.warn((Object)LogFormatUtils.formatValue((Object)("Resource path \"" + resourcePath + "\" was successfully resolved but resource \"" + resource + "\" is neither under the current location \"" + location + "\" nor under any of the allowed locations " + (allowed != null ? Arrays.asList(allowed) : "[]")), (int)-1, (boolean)true));
                }
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                String error = "Skip location [" + location + "] due to error";
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)error, (Throwable)ex);
                } else {
                    this.logger.debug((Object)(error + ": " + ex.getMessage()));
                }
            }
            return Mono.error((Throwable)ex);
        }
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (this.isResourceUnderLocation(resource, location)) {
            return true;
        }
        if (this.getAllowedLocations() != null) {
            for (Resource current : this.getAllowedLocations()) {
                if (!this.isResourceUnderLocation(resource, current)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            resourcePath = classPathResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        return resourcePath.startsWith(locationPath) && !this.isInvalidEncodedPath(resourcePath);
    }

    private boolean isInvalidEncodedPath(String resourcePath) {
        if (resourcePath.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(resourcePath, StandardCharsets.UTF_8);
                if (decodedPath.contains("../") || decodedPath.contains("..\\")) {
                    this.logger.warn((Object)LogFormatUtils.formatValue((Object)("Resolved resource path contains encoded \"../\" or \"..\\\": " + resourcePath), (int)-1, (boolean)true));
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }
}

