/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.context.ExceptionHandlerFactory;
import jakarta.faces.context.ExternalContextFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.context.PartialViewContextFactory;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.facelets.FaceletCacheFactory;
import jakarta.faces.view.facelets.TagHandlerDelegateFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfUtils {
    private static final Map<Class<?>, String> FACTORY_NAMES = new HashMap();

    public static void notifyAfterListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent afterPhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = lifecycle.getPhaseListeners().length - 1; i >= 0; --i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.afterPhase(afterPhaseEvent);
        }
    }

    public static void notifyBeforeListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent beforePhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = 0; i < lifecycle.getPhaseListeners().length; ++i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.beforePhase(beforePhaseEvent);
        }
    }

    public static boolean isFlowRequest() {
        return RequestContextHolder.getRequestContext() != null;
    }

    public static boolean isAsynchronousFlowRequest() {
        return JsfUtils.isFlowRequest() && RequestContextHolder.getRequestContext().getExternalContext().isAjaxRequest();
    }

    public static <T> T findFactory(Class<T> factoryClass) {
        Assert.notNull(factoryClass, (String)"FactoryClass must not be null");
        String name = FACTORY_NAMES.get(factoryClass);
        Assert.state((name != null ? 1 : 0) != 0, (String)("Unknown factory class " + factoryClass.getName()));
        return (T)FactoryFinder.getFactory((String)name);
    }

    static {
        FACTORY_NAMES.put(ApplicationFactory.class, "jakarta.faces.application.ApplicationFactory");
        FACTORY_NAMES.put(ExceptionHandlerFactory.class, "jakarta.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.put(ExternalContextFactory.class, "jakarta.faces.context.ExternalContextFactory");
        FACTORY_NAMES.put(FaceletCacheFactory.class, "jakarta.faces.view.facelets.FaceletCacheFactory");
        FACTORY_NAMES.put(FacesContextFactory.class, "jakarta.faces.context.FacesContextFactory");
        FACTORY_NAMES.put(LifecycleFactory.class, "jakarta.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.put(PartialViewContextFactory.class, "jakarta.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.put(RenderKitFactory.class, "jakarta.faces.render.RenderKitFactory");
        FACTORY_NAMES.put(TagHandlerDelegateFactory.class, "jakarta.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.put(ViewDeclarationLanguageFactory.class, "jakarta.faces.view.ViewDeclarationLanguageFactory");
        FACTORY_NAMES.put(VisitContextFactory.class, "jakarta.faces.component.visit.VisitContextFactory");
    }
}

