/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;

public class TileCache {
    private Map<URI, BufferedImage> imgmap = new HashMap<URI, BufferedImage>();
    private LinkedList<URI> imgmapAccessQueue = new LinkedList();
    private int imagesize = 0;
    private Map<URI, byte[]> bytemap = new HashMap<URI, byte[]>();
    private LinkedList<URI> bytemapAccessQueue = new LinkedList();
    private int bytesize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URI uri, byte[] bimg, BufferedImage img) {
        Map<URI, byte[]> map = this.bytemap;
        synchronized (map) {
            while (this.bytesize > 50000000) {
                URI olduri = this.bytemapAccessQueue.removeFirst();
                byte[] oldbimg = this.bytemap.remove(olduri);
                this.bytesize -= oldbimg.length;
                this.p("removed 1 img from byte cache");
            }
            this.bytemap.put(uri, bimg);
            this.bytesize += bimg.length;
            this.bytemapAccessQueue.addLast(uri);
        }
        this.addToImageCache(uri, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(URI uri) throws IOException {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            if (this.imgmap.containsKey(uri)) {
                this.imgmapAccessQueue.remove(uri);
                this.imgmapAccessQueue.addLast(uri);
                return this.imgmap.get(uri);
            }
        }
        map = this.bytemap;
        synchronized (map) {
            if (this.bytemap.containsKey(uri)) {
                this.p("retrieving from bytes");
                this.bytemapAccessQueue.remove(uri);
                this.bytemapAccessQueue.addLast(uri);
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(this.bytemap.get(uri)));
                this.addToImageCache(uri, img);
                return img;
            }
        }
        return null;
    }

    public void needMoreMemory() {
        this.imgmap.clear();
        this.p("HACK! need more memory: freeing up memory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToImageCache(URI uri, BufferedImage img) {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            while (this.imagesize > 50000000) {
                URI olduri = this.imgmapAccessQueue.removeFirst();
                BufferedImage oldimg = this.imgmap.remove(olduri);
                this.imagesize -= oldimg.getWidth() * oldimg.getHeight() * 4;
                this.p("removed 1 img from image cache");
            }
            this.imgmap.put(uri, img);
            this.imagesize += img.getWidth() * img.getHeight() * 4;
            this.imgmapAccessQueue.addLast(uri);
        }
        this.p("added to cache:  uncompressed = " + this.imgmap.keySet().size() + " / " + this.imagesize / 1000 + "k" + " compressed = " + this.bytemap.keySet().size() + " / " + this.bytesize / 1000 + "k");
    }

    private void p(String string) {
    }
}

