/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.mongodb;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MongoDBAtlasLocalContainer
extends GenericContainer<MongoDBAtlasLocalContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mongodb/mongodb-atlas-local");
    private static final int MONGODB_INTERNAL_PORT = 27017;

    public MongoDBAtlasLocalContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public MongoDBAtlasLocalContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{27017});
        this.waitingFor((WaitStrategy)Wait.forSuccessfulCommand((String)"runner healthcheck"));
    }

    public String getConnectionString() {
        return String.format("mongodb://%s:%d/?directConnection=true", this.getHost(), this.getMappedPort(27017));
    }
}

