/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import ognl.OgnlException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.Aggregates;
import org.thymeleaf.expression.Arrays;
import org.thymeleaf.expression.Bools;
import org.thymeleaf.expression.Calendars;
import org.thymeleaf.expression.Dates;
import org.thymeleaf.expression.Lists;
import org.thymeleaf.expression.Maps;
import org.thymeleaf.expression.Numbers;
import org.thymeleaf.expression.Objects;
import org.thymeleaf.expression.Sets;
import org.thymeleaf.expression.Strings;
import org.thymeleaf.expression.Temporals;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.util.Validate;

public final class OgnlTestContextExpression
implements ITestContextExpression {
    private static final ConcurrentHashMap<Locale, Map<String, Object>> EXPRESSION_EVALUATION_UTILITY_OBJECTS_BY_LOCALE = new ConcurrentHashMap();
    private final String expression;

    public OgnlTestContextExpression(String expression) {
        Validate.notNull((Object)expression, (String)"Expression cannot be null or empty");
        this.expression = expression.trim().equals("") ? "''" : expression;
    }

    @Override
    public Object evaluate(Map<String, Object> context, Locale locale) {
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        Map<String, Object> expressionUtilityObjects = OgnlTestContextExpression.buildExpressionEvaluationUtilityObjects(locale);
        if (expressionUtilityObjects != null) {
            contextVariables.putAll(expressionUtilityObjects);
        }
        try {
            Object varExpression = Ognl.parseExpression((String)this.expression);
            return Ognl.getValue((Object)varExpression, contextVariables, context);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + this.expression + "\"", (Throwable)e);
        }
    }

    private static Map<String, Object> buildExpressionEvaluationUtilityObjects(Locale locale) {
        Map<String, Object> objects = EXPRESSION_EVALUATION_UTILITY_OBJECTS_BY_LOCALE.get(locale);
        if (objects == null) {
            objects = new HashMap<String, Object>(30);
            if (locale != null) {
                objects.put("temporals", new Temporals(locale));
                objects.put("calendars", new Calendars(locale));
                objects.put("dates", new Dates(locale));
                objects.put("numbers", new Numbers(locale));
                objects.put("strings", new Strings(locale));
            }
            objects.put("bools", new Bools());
            objects.put("objects", new Objects());
            objects.put("arrays", new Arrays());
            objects.put("lists", new Lists());
            objects.put("sets", new Sets());
            objects.put("maps", new Maps());
            objects.put("aggregates", new Aggregates());
            EXPRESSION_EVALUATION_UTILITY_OBJECTS_BY_LOCALE.put(locale, objects);
        }
        return new HashMap<String, Object>(objects);
    }
}

