/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import java.io.File;
import java.io.FileInputStream;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.AbstractTestResource;
import org.thymeleaf.testing.templateengine.resource.ILocalTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.util.EscapeUtils;
import org.thymeleaf.testing.templateengine.util.ResourceUtils;
import org.thymeleaf.util.Validate;

public class LocalFileTestResource
extends AbstractTestResource
implements ITestResourceItem,
ILocalTestResource {
    private final File resourceFile;
    private final String characterEncoding;
    private final boolean avoidUnicodeUnescapeOnRead;

    public LocalFileTestResource(File file, String characterEncoding) {
        this(file, characterEncoding, false);
    }

    public LocalFileTestResource(File file, String characterEncoding, boolean avoidUnicodeUnescapeOnRead) {
        super(LocalFileTestResource.validateFile(file));
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        this.resourceFile = file.getAbsoluteFile();
        this.characterEncoding = characterEncoding;
        this.avoidUnicodeUnescapeOnRead = avoidUnicodeUnescapeOnRead;
    }

    private static String validateFile(File file) {
        Validate.notNull((Object)file, (String)"Resource file cannot be null");
        return file.getAbsolutePath();
    }

    @Override
    public File getResourceFile() {
        return this.resourceFile;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public String readAsText() {
        try {
            FileInputStream is = new FileInputStream(this.resourceFile);
            String text = ResourceUtils.read(is, this.characterEncoding);
            return this.avoidUnicodeUnescapeOnRead ? text : EscapeUtils.unescapeUnicode(text);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Error reading file resource: \"" + this.getName() + "\"", e);
        }
    }
}

