/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.testable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.thymeleaf.testing.templateengine.testable.AbstractTestable;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;
import org.thymeleaf.testing.templateengine.testable.ITestable;
import org.thymeleaf.util.Validate;

public class TestSequence
extends AbstractTestable
implements ITestSequence {
    private List<ITestable> elements = new ArrayList<ITestable>();

    public TestSequence() {
    }

    public TestSequence(ITestable ... testables) {
        Validate.notNull((Object)testables, (String)"Testable object assignation cannot be null");
        for (int i = 0; i < testables.length; ++i) {
            this.addElement(testables[i]);
        }
    }

    public void addElement(ITestable testable) {
        Validate.notNull((Object)testable, (String)"Testable object cannot be null");
        this.elements.add(testable);
    }

    public void addElements(Collection<? extends ITestable> testables) {
        Validate.notNull(testables, (String)"Testable collection cannot be null");
        Validate.containsNoNulls(testables, (String)"Testable collection cannot contain nulls");
        this.elements.addAll(testables);
    }

    public void clearElements() {
        this.elements.clear();
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public List<ITestable> getElements() {
        return Collections.unmodifiableList(this.elements);
    }
}

