/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ExpressionCacheKey;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring3.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring3.expression.SPELContextMapWrapper;
import org.thymeleaf.spring3.expression.SpringStandardConversionService;
import org.thymeleaf.spring3.expression.ThymeleafEvaluationContextWrapper;
import org.thymeleaf.spring3.util.FieldUtils;
import org.thymeleaf.spring3.util.SpringStandardExpressionUtils;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.util.StandardExpressionUtils;

public class SPELVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    public static final SPELVariableExpressionEvaluator INSTANCE = new SPELVariableExpressionEvaluator();
    private static final String EXPRESSION_CACHE_TYPE_SPEL = "spel";
    private static final Logger logger = LoggerFactory.getLogger(SPELVariableExpressionEvaluator.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    protected SPELVariableExpressionEvaluator() {
    }

    public final Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] SpringEL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression.getExpression());
        }
        try {
            SPELContextMapWrapper evaluationRoot;
            BindStatus bindStatus;
            String spelExpression = expression.getExpression();
            boolean useSelectionAsRoot = expression.getUseSelectionAsRoot();
            if (spelExpression == null) {
                throw new TemplateProcessingException("Expression content is null, which is not allowed");
            }
            if (expContext.getPerformTypeConversion() && (useSelectionAsRoot || !SPELVariableExpressionEvaluator.isLocalVariableOverriding(context, spelExpression)) && (bindStatus = FieldUtils.getBindStatusFromParsedExpression(context, true, useSelectionAsRoot, spelExpression)) != null) {
                return ValueFormatterWrapper.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), false);
            }
            IEngineConfiguration configuration = context.getConfiguration();
            ComputedSpelExpression exp = SPELVariableExpressionEvaluator.obtainComputedSpelExpression(configuration, expression, spelExpression, expContext);
            IExpressionObjects expressionObjects = exp.mightNeedExpressionObjects ? context.getExpressionObjects() : null;
            EvaluationContext evaluationContext = (EvaluationContext)context.getVariable("thymeleaf::EvaluationContext");
            if (evaluationContext == null) {
                evaluationContext = new ThymeleafEvaluationContextWrapper((EvaluationContext)new StandardEvaluationContext());
                if (context instanceof IEngineContext) {
                    ((IEngineContext)context).setVariable("thymeleaf::EvaluationContext", (Object)evaluationContext);
                }
            } else if (!(evaluationContext instanceof IThymeleafEvaluationContext)) {
                evaluationContext = new ThymeleafEvaluationContextWrapper(evaluationContext);
                if (context instanceof IEngineContext) {
                    ((IEngineContext)context).setVariable("thymeleaf::EvaluationContext", (Object)evaluationContext);
                }
            }
            IThymeleafEvaluationContext thymeleafEvaluationContext = (IThymeleafEvaluationContext)evaluationContext;
            thymeleafEvaluationContext.setExpressionObjects(expressionObjects);
            thymeleafEvaluationContext.setVariableAccessRestricted(expContext.getRestrictVariableAccess());
            ITemplateContext templateContext = context instanceof ITemplateContext ? (ITemplateContext)context : null;
            SPELContextMapWrapper sPELContextMapWrapper = evaluationRoot = useSelectionAsRoot && templateContext != null && templateContext.hasSelectionTarget() ? templateContext.getSelectionTarget() : new SPELContextMapWrapper((IContext)context, thymeleafEvaluationContext);
            if (!expContext.getPerformTypeConversion()) {
                return exp.expression.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot);
            }
            IStandardConversionService conversionService = StandardExpressions.getConversionService((IEngineConfiguration)configuration);
            if (conversionService instanceof SpringStandardConversionService) {
                return exp.expression.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot, String.class);
            }
            Object result = exp.expression.getValue((EvaluationContext)thymeleafEvaluationContext, (Object)evaluationRoot);
            return conversionService.convert(context, result, String.class);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating SpringEL expression: \"" + expression.getExpression() + "\"", (Throwable)e);
        }
    }

    private static ComputedSpelExpression obtainComputedSpelExpression(IEngineConfiguration configuration, IStandardVariableExpression expression, String spelExpression, StandardExpressionExecutionContext expContext) {
        if (expContext.getRestrictInstantiationAndStatic() && SpringStandardExpressionUtils.containsSpELInstantiationOrStaticOrParam(spelExpression)) {
            throw new TemplateProcessingException("Instantiation of new objects and access to static classes or parameters is forbidden in this context");
        }
        if (expression instanceof VariableExpression) {
            VariableExpression vexpression = (VariableExpression)expression;
            Object cachedExpression = vexpression.getCachedExpression();
            if (cachedExpression != null && cachedExpression instanceof ComputedSpelExpression) {
                return (ComputedSpelExpression)cachedExpression;
            }
            cachedExpression = SPELVariableExpressionEvaluator.getExpression(configuration, spelExpression);
            if (cachedExpression != null) {
                vexpression.setCachedExpression(cachedExpression);
            }
            return (ComputedSpelExpression)cachedExpression;
        }
        if (expression instanceof SelectionVariableExpression) {
            SelectionVariableExpression vexpression = (SelectionVariableExpression)expression;
            Object cachedExpression = vexpression.getCachedExpression();
            if (cachedExpression != null && cachedExpression instanceof ComputedSpelExpression) {
                return (ComputedSpelExpression)cachedExpression;
            }
            cachedExpression = SPELVariableExpressionEvaluator.getExpression(configuration, spelExpression);
            if (cachedExpression != null) {
                vexpression.setCachedExpression(cachedExpression);
            }
            return (ComputedSpelExpression)cachedExpression;
        }
        return SPELVariableExpressionEvaluator.getExpression(configuration, spelExpression);
    }

    private static ComputedSpelExpression getExpression(IEngineConfiguration configuration, String spelExpression) {
        ComputedSpelExpression exp = null;
        ICache cache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            exp = (ComputedSpelExpression)cache.get((Object)new ExpressionCacheKey(EXPRESSION_CACHE_TYPE_SPEL, spelExpression));
        }
        if (exp == null) {
            boolean mightNeedExpressionObjects = StandardExpressionUtils.mightNeedExpressionObjects((String)spelExpression);
            SpelExpression spelExpressionObject = (SpelExpression)PARSER.parseExpression(spelExpression);
            exp = new ComputedSpelExpression(spelExpressionObject, mightNeedExpressionObjects);
            if (cache != null && null != exp) {
                cache.put((Object)new ExpressionCacheKey(EXPRESSION_CACHE_TYPE_SPEL, spelExpression), (Object)exp);
            }
        }
        return exp;
    }

    private static boolean isLocalVariableOverriding(IExpressionContext context, String expression) {
        if (!(context instanceof IEngineContext)) {
            return false;
        }
        IEngineContext engineContext = (IEngineContext)context;
        int dotPos = expression.indexOf(46);
        if (dotPos == -1) {
            return false;
        }
        String expressionFirstComponent = expression.substring(0, dotPos);
        return engineContext.isVariableLocal(expressionFirstComponent);
    }

    public String toString() {
        return "SpringEL";
    }

    private static final class ComputedSpelExpression {
        final SpelExpression expression;
        final boolean mightNeedExpressionObjects;

        ComputedSpelExpression(SpelExpression expression, boolean mightNeedExpressionObjects) {
            this.expression = expression;
            this.mightNeedExpressionObjects = mightNeedExpressionObjects;
        }
    }
}

